<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;
?>
<section class="prime-slider-slide <?php echo $slide->className; ?>" style="<?php echo $slide->cssStyles; ?>" data-position="<?php echo ($key + 1); ?>">
    <div class="prime-slide-inner">
        <?php if ($slide->image) : ?>
            <?php if ($params->get('lazyload', 1)) : ?>
                <img src="data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgd2lkdGg9IjEiIGhlaWdodD0iMSIvPg==" data-src="<?php echo Uri::root(true) . '/' . $slide->image; ?>" <?php echo $slide->image_size ? ' ' . $slide->image_size : ''; ?> alt="<?php echo $slide->image_alt; ?>" class="prime-slide-image tns-lazy-img" />
            <?php else : ?>
                <img src="<?php echo Uri::root(true) . '/' . $slide->image; ?>" <?php echo $slide->image_size ? ' ' . $slide->image_size : ''; ?> alt="<?php echo $slide->image_alt; ?>" class="prime-slide-image" <?php echo $key > 0 ? ' loading="lazy"' : ''; ?> />
            <?php endif; ?>
        <?php endif; ?>

        <div class="prime-slide-container">
            <div class="prime-slide-text-area">
                <?php if (!empty($slide->subheading_text)) : ?>
                    <h3 class="prime-slide-subheading">
                        <?php echo $slide->subheading_text; ?>
                    </h3>
                <?php endif; ?>

                <?php if (!empty($slide->heading_text)) : ?>
                    <h1 class="prime-slide-heading">
                        <?php echo $slide->heading_text; ?>
                    </h1>
                <?php endif; ?>

                <?php if (!empty($slide->paragraph_text)) : ?>
                    <p class="prime-slide-paragraph">
                        <?php echo $slide->paragraph_text; ?>
                    </p>
                <?php endif; ?>

                <?php if (!empty($slide->button_1_text) || !empty($slide->button_2_text) || !empty($slide->button_3_text)) : ?>
                    <div class="prime-slide-buttons">
                        <?php if (!empty($slide->button_1_text)) : ?>
                            <a href="<?php echo $slide->button_1_url; ?>" class="btn <?php echo $slide->button_1_class; ?> btn-lg">
                                <?php echo $slide->button_1_text; ?>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($slide->button_2_text)) : ?>
                            <a href="<?php echo $slide->button_2_url; ?>" class="btn <?php echo $slide->button_2_class; ?> btn-lg">
                                <?php echo $slide->button_2_text; ?>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($slide->button_3_text)) : ?>
                            <a href="<?php echo $slide->button_3_url; ?>" class="btn <?php echo $slide->button_3_class; ?> btn-lg">
                                <?php echo $slide->button_3_text; ?>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php if ($slide->url) : ?>
        <a href="<?php echo $slide->url; ?>" class="prime-slide-link" aria-hidden="true" tabindex="-1"></a>
    <?php endif; ?>
</section>