<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Helper\ModuleHelper;
use Virtueplanet\Plugin\System\Prime\Helper\GlobalHelper;

defined('_JEXEC') or die;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa           = $app->getDocument()->getWebAssetManager();
$idTag        = 'PrimeSlider-' . $module->id;
$globalHelper = GlobalHelper::getInstance();

if ($wa->assetExists('preset', 'tiny-slider')) {
    $wa->usePreset('tiny-slider');
} else {
    $wa->registerAndUseScript('mod_vpprime_slider.tiny-slider', 'mod_vpprime_slider/tiny-slider.min.js', ['version' => 'v2.9.3'], ['defer' => true]);
    $wa->registerAndUseStyle('mod_vpprime_slider.tiny-slider', 'mod_vpprime_slider/tiny-slider.min.css', ['version' => 'v2.9.3']);
}

$wa->useScript('core');
$wa->registerAndUseScript('mod_vpprime_slider', 'mod_vpprime_slider/module.min.js', ['version' => 'v1.1'], ['defer' => true]);
$wa->registerAndUseStyle('mod_vpprime_slider', 'mod_vpprime_slider/module.min.css', ['version' => 'v1.2']);

$options = [
    'container'            => '#' . $idTag . ' .prime-slider-slides',
    'mode'                 => $params->get('mode', 'gallery'),
    'loop'                 => true,
    'mouseDrag'            => false,
    'slideBy'              => 'page',
    'edgePadding'          => 0,
    'gutter'               => 0,
    'speed'                => (int) $params->get('speed', 300),
    'autoplay'             => (bool) $params->get('autoplay', 1),
    'autoplayHoverPause'   => true,
    'autoplayButtonOutput' => false,
    'autoplayTimeout'      => (int) $params->get('autoplayTimeout', 5000),
    'lazyload'             => (bool) $params->get('lazyload', 1),
    'controls'             => (bool) $params->get('controls', 1),
    'controlsContainer'    => '#' . $idTag . ' .prime-slider-controls',
    'nav'                  => (bool) $params->get('nav', 0),
    'navContainer'         => '#' . $idTag . ' .prime-slider-navigation',
    'items'                => 1
];

// Get existing slider configs and append this one
$configs = $globalHelper->getData('vpprime.slider', []);

if (empty($configs) || !is_array($configs)) {
    $configs = [];
}

$key           = (int) $module->id;
$configs[$key] = $options;

// Store the updated configs
$globalHelper->setData('vpprime.slider', $configs);

// Add the configs to document script options
$document->addScriptOptions('vpprime.slider', array_values($configs), false);

$lazyLoad   = $params->get('lazyload', 1);
$imageClass = $lazyLoad ? 'slider-image tns-lazy-img' : 'slider-image';
?>
<div id="<?php echo $idTag; ?>" class="prime-slider">
    <div class="prime-slider-slides">
        <?php foreach ($items as $key => $slide) : ?>
            <?php require ModuleHelper::getLayoutPath('mod_vpprime_slider', $params->get('layout', 'default') . '_slide'); ?>
        <?php endforeach; ?>
    </div>
    <?php if ($params->get('controls', 1)) : ?>
        <div class="prime-slider-controls d-none" aria-label="Slider Navigation" tabindex="0">
            <button type="button" data-controls="prev" tabindex="-1">
                <i class="vpi vpi-chevron-left" aria-hidden="true"></i>
                <span class="visually-hidden">Prev</span>
            </button>
            <button type="button" data-controls="next" tabindex="-1">
                <i class="vpi vpi-chevron-right" aria-hidden="true"></i>
                <span class="visually-hidden">Next</span>
            </button>
        </div>
    <?php endif; ?>
    <?php if ($params->get('nav', 0)) : ?>
        <div class="prime-slider-navigation d-none" aria-label="Slider Pagination" tabindex="0">
            <?php for ($i = 0; $i < count($items); $i++) : ?>
                <button type="button" data-nav="<?php echo $i; ?>" tabindex="-1" aria-label="Slider Page <?php echo($i + 1); ?>"></button>
            <?php endfor; ?>
        </div>
    <?php endif; ?>
</div>
