<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Module\Slider\Site\Helper;

use Joomla\CMS\Cache\CacheControllerFactoryInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Filesystem\Path;
use Joomla\CMS\Helper\MediaHelper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Helper for mod_vpprime_slider
 */
class SliderHelper
{
    public static function getList($module, $params)
    {
        /** @var OutputController $cache */
        $cache = Factory::getContainer()->get(CacheControllerFactoryInterface::class)
            ->createCacheController('output', ['defaultgroup' => 'mod_vpprime_slider']);

        // Compose cache key
        $cacheKey = 'slides:' . $params;

        if ($cache->contains($cacheKey)) {
            $items = $cache->get($cacheKey);
        } else {
            $slides = $params->get('slides', []);
            $items  = [];
            $i      = 1;

            foreach ($slides as $slide) {
                if ($slide->image_position_vertical === 'custom') {
                    $slide->image_position_vertical = $slide->image_position_vertical_custom;
                } else {
                    unset($slide->image_position_vertical_custom);
                }

                if ($slide->image_position_horizontal === 'custom') {
                    $slide->image_position_horizontal = $slide->image_position_horizontal_custom;
                } else {
                    unset($slide->image_position_horizontal_custom);
                }

                if ($slide->vertical_position === 'center') {
                    unset($slide->vertical_offset); // Remember to deal with offset css.
                }

                if ($slide->horizontal_position === 'center') {
                    unset($slide->horizontal_offset); // Remember to deal with offset css.
                }

                $slide->height      = $params->get('height');
                $slide->slide_speed = $params->get('speed');

                $cssVars = [];

                foreach ($slide as $key => $value) {
                    if (strpos($key, 'text') !== false || strpos($key, 'url') !== false) {
                        $slide->{$key} = $value ? trim($value) : $value;
                    }

                    if (empty($value) || strpos($key, 'class') !== false || strpos($key, '_text') !== false || strpos($key, 'url') !== false || (strpos($key, 'image') !== false) && strpos($key, 'image_position') === false && strpos($key, 'image_fit') === false) {
                        continue;
                    }

                    $cssKey = '--' . str_replace('_', '-', $key);

                    if (is_object($value)) {
                        foreach ($value as $cKey => $cValue) {
                            $cKey = $cssKey . '-' . str_replace('_', '-', $cKey);

                            $cssVars[$cKey] = $cValue;
                        }
                    } else {
                        if ($key === 'fade_in') {
                            $cssVars['--opacity'] = $value ? '0' : '1';
                        } else {
                            $cssVars[$cssKey] = $value;
                        }
                    }
                }

                $slide->className    = 'prime-slide-' . $module->id . '-' . $i;
                $slide->image_width  = '';
                $slide->image_height = '';
                $slide->image_size   = '';

                if ($slide->image) {
                    $slide->image = MediaHelper::getCleanMediaFieldValue($slide->image);
                    $fileName     = Path::clean(JPATH_ROOT . '/' . $slide->image);

                    if (File::exists($fileName)) {
                        $fileInfo = getimagesize($fileName);

                        if (!empty($fileInfo)) {
                            if (!empty($fileInfo[0])) {
                                $slide->image_width = $fileInfo[0];
                            }

                            if (!empty($fileInfo[1])) {
                                $slide->image_height = $fileInfo[1];
                            }
                        }

                        if (!empty($slide->image_width) && !empty($slide->image_height)) {
                            $slide->image_size = 'width="' . $slide->image_width . '" height="' . $slide->image_height . '"';
                        }

                        if (empty($slide->image_alt)) {
                            $slide->image_alt = 'Slide ' . $i;
                        }
                    } else {
                        $slide->image = '';
                    }
                }

                $slide->cssVars = $cssVars;

                $cssStyles = [];

                foreach ($cssVars as $cssKey => $cssValue) {
                    $cssStyles[] = $cssKey . ': ' . $cssValue;
                }

                $slide->cssStyles = implode('; ', $cssStyles);

                $items[] = $slide;

                $i++;

                $cache->store($items, $cacheKey);
            }
        }

        return $items;
    }
}
