<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app        = Factory::getApplication();
$template   = $app->getTemplate(true);
$params     = $template->params;
$lazyLoad   = $params->get('vm_image_lazyload', 0);
$imageClass = $lazyLoad ? 'product-image lazy' : 'product-image';
?>
<div class="vppl<?php echo !empty($moduleclass_sfx) ? ' ' . $moduleclass_sfx : ''; ?>">
    <ul class="vppl-list">
        <?php foreach ($products as $product) : ?>
            <li>
                <div class="vppl-inner">
                    <div class="row gx-4">
                        <div class="col-4">
                            <div class="vppl-image-cont">
                                <a href="<?php echo Route::_(VirtuemartHelper::getProductUrl($product)); ?>">
                                    <?php echo VirtuemartHelper::prepareLazyImageHTML($product->images[0]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad); ?>
                                </a>
                            </div>
                        </div>
                        <div class="col-8">
                            <h4 class="vppl-name">
                                <a href="<?php echo Route::_(VirtuemartHelper::getProductUrl($product)); ?>" title="<?php echo $product->product_name; ?>" class="link-body">
                                    <?php echo $product->product_name; ?>
                                </a>
                            </h4>
                            <?php if ($showPrice) : ?>
                                <div class="vppl-price-cont">
                                    <?php echo shopFunctionsF::renderVmSubLayout('prices', ['product' => $product, 'currency' => $currency, 'showDetails' => false, 'displayedPriceType' => $params->get('displayed_price_type', 'salesPrice')]); ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($showRating && !empty($product->rating)) : ?>
                                <div class="vppl-rating-cont">
                                    <?php echo shopFunctionsF::renderVmSubLayout('rating', ['showRating' => $showRating, 'product' => $product, 'readonly' => true]); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </li>
        <?php endforeach; ?>
    </ul>
</div>