<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Virtueplanet\Module\ProductList\Site\Helper;

// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

abstract class ModuleHelper
{
    public static function getList($params)
    {
        \JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');

        \VmConfig::loadConfig();
        \VmConfig::loadJLang('com_virtuemart', true);

        $group             = $params->get('product_group', 'featured');
        $max_items         = $params->get('max_items', 2);
        $product_ids       = (array) $params->get('product_id', []);
        $category_id       = $params->get('virtuemart_category_id', null);
        $filter_category   = !empty($category_id) ? true : false;
        $show_price        = $params->get('show_price', 1);
        /** @var \VirtueMartModelProduct $model */
        $model             = \VmModel::getModel('Product');
        $ratingModel       = \VmModel::getModel('ratings');
        $model->withRating = $params->get('show_rating', 1) && $ratingModel->showRating();

        if ($group == 'custom') {
            if (!empty($product_ids)) {
                if (isset(\VirtueMartModelProduct::$_alreadyLoadedIds)) {
                    \VirtueMartModelProduct::$_alreadyLoadedIds = [];
                }

                $products = $model->getProducts($product_ids);

                if (isset(\VirtueMartModelProduct::$_alreadyLoadedIds)) {
                    \VirtueMartModelProduct::$_alreadyLoadedIds = [];
                }
            } else {
                $products = [];
            }
        } else {
            if (isset(\VirtueMartModelProduct::$_alreadyLoadedIds)) {
                \VirtueMartModelProduct::$_alreadyLoadedIds = [];
            }

            $products = $model->getProductListing($group, $max_items, $show_price, true, false, $filter_category, $category_id);

            if (isset(\VirtueMartModelProduct::$_alreadyLoadedIds)) {
                \VirtueMartModelProduct::$_alreadyLoadedIds = [];
            }
        }

        if (!empty($products)) {
            $model->addImages($products, 1);
        }

        return $products;
    }
}
