<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\GlobalHelper;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa           = $app->getDocument()->getWebAssetManager();
$idTag        = 'PrimeProductCarousel-' . $module->id;
$globalHelper = GlobalHelper::getInstance();

vmJsApi::jPrice();
vmJsApi::cssSite();

if ($wa->assetExists('preset', 'tiny-slider')) {
    $wa->usePreset('tiny-slider');
} else {
    $wa->registerAndUseScript('mod_vpprime_slider.tiny-slider', 'mod_vpprime_slider/tiny-slider.min.js', ['version' => 'v2.9.3'], ['defer' => true]);
    $wa->registerAndUseStyle('mod_vpprime_slider.tiny-slider', 'mod_vpprime_slider/tiny-slider.min.css', ['version' => 'v2.9.3']);
}

$wa->useScript('core');
$wa->registerAndUseScript('mod_vpprime_product_carousel', 'mod_vpprime_product_carousel/module.min.js', ['version' => 'v1.2'], ['defer' => true]);

$options = [
    'container'            => '#' . $idTag,
    'loop'                 => false,
    'mouseDrag'            => false,
    'slideBy'              => 'page',
    'edgePadding'          => 12,
    'gutter'               => (float) $params->get('gutter', 28),
    'speed'                => (int) $params->get('speed', 300),
    'rewind'               => true,
    'autoplay'             => (bool) $params->get('autoplay', 0),
    'autoplayHoverPause'   => true,
    'autoplayButtonOutput' => false,
    'autoplayTimeout'      => (int) $params->get('autoplayTimeout', 5000),
    'lazyload'             => (bool) $params->get('lazyload', 1),
    'controls'             => (bool) $params->get('controls', 1),
    'controlsText'         => [
        '<i class="vpi vpi-chevron-left" aria-hidden="true"></i><span class="visually-hidden">Prev</span>',
        '<i class="vpi vpi-chevron-right" aria-hidden="true"></i><span class="visually-hidden">Next</span>'
    ],
    'nav'                  => (bool) $params->get('nav', 0),
    'navPosition'          => $params->get('navPosition', 'bottom'),
    'items'                => (int) $params->get('items', 2),
    'responsive'           => [
        576 => [
            'items' => (int) $params->get('itemsSm', 2)
        ],
        768 => [
            'items' => (int) $params->get('itemsMd', 3)
        ],
        992 => [
            'items'       => (int) $params->get('itemsLg', 4),
            'edgePadding' => 20
        ]
    ]
];

// Get existing carousel configs and append this one
$configs = $globalHelper->getData('vpprime.product.carousel', []);

if (empty($configs) || !is_array($configs)) {
    $configs = [];
}

$key           = (int) $module->id;
$configs[$key] = $options;

// Store the updated configs
$globalHelper->setData('vpprime.product.carousel', $configs);

// Add the configs to document script options
$document->addScriptOptions('vpprime.product.carousel', array_values($configs), false);

$lazyLoad   = $params->get('lazyload', 1);
$imageClass = $lazyLoad ? 'product-thumbnail tns-lazy-img' : 'product-thumbnail';
?>
<div id="<?php echo $idTag; ?>" class="vpprime-product-carousel tns-initial-container">
    <?php foreach ($products as $product) : ?>
        <?php if (!is_object($product) || empty($product->link)) : ?>
            <?php continue; ?>
        <?php endif; ?>

        <?php $productLink = Route::_(VirtuemartHelper::getProductUrl($product)); ?>

        <div class="vpprime-product-carousel-item">
            <div class="product product-grid-view">
                <div class="product-container add-hover-effect w-100 d-flex flex-column align-self-start" data-vm="product-container">
                    <div class="product-top-container">
                        <div class="product-list-images mb-3 text-center">
                            <div class="product-image-default">
                                <a href="<?php echo $productLink; ?>">
                                    <?php echo VirtuemartHelper::prepareLazyImageHTML($product->images[0]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad); ?>
                                </a>
                            </div>
                            <?php if ($params->get('products_mouseover_image_change', 1) && !empty($product->images[1])) : ?>
                                <div class="product-image-hover">
                                    <a href="<?php echo $productLink; ?>">
                                        <?php echo VirtuemartHelper::prepareLazyImageHTML($product->images[1]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <?php echo shopFunctionsF::renderVmSubLayout('productlabels', ['product' => $product]); ?>
                            <?php echo shopFunctionsF::renderVmSubLayout('utilities', ['product' => $product, 'isWishlist' => false]); ?>
                        </div>
                        <h3 class="product-name text-center m-0 mb-2">
                            <a href="<?php echo $productLink; ?>"><?php echo $product->product_name; ?></a>
                        </h3>
                        <?php if ($showCategories && !empty($product->categories)) : ?>
                            <?php $categoryNames = VirtuemartHelper::getCategoryNames($product->categories); ?>
                            <div class="product-categories text-center text-muted mb-2">
                                <?php echo implode(', ', $categoryNames); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($showRating && !empty($product->rating)) : ?>
                            <div class="product-rating text-center mb-2">
                                <?php echo shopFunctionsF::renderVmSubLayout('rating', ['showRating' => $showRating, 'product' => $product, 'readonly' => true]); ?>
                            </div>
                        <?php endif; ?>
                        <?php if ($showPrice) : ?>
                            <div class="product-prices text-center mb-3">
                                <?php echo shopFunctionsF::renderVmSubLayout('prices', ['product' => $product, 'currency' => $currency, 'showDetails' => $params->get('products_show_all_prices', 0)]); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if (($showShortDesc && !empty($product->product_s_desc)) || $showAddToCart) : ?>
                        <div class="product-bottom-container pb-4">
                            <?php if ($showShortDesc && !empty($product->product_s_desc)) : ?>
                                <?php if ($product->product_s_desc != strip_tags($product->product_s_desc)) : ?>
                                    <div class="product-short-description text-center mb-3">
                                        <?php echo $product->product_s_desc; ?>
                                    </div>
                                <?php else : ?>
                                    <p class="product-short-description text-center mb-3">
                                        <?php echo nl2br($product->product_s_desc); ?>
                                    </p>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if ($showAddToCart) : ?>
                                <?php echo shopFunctionsF::renderVmSubLayout('addtocart', ['product' => $product, 'isList' => true, 'listMode' => 'grid']); ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="product-backdrop" aria-hidden="true" tabindex="-1"></div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php echo vmJsApi::writeJS(); ?>
