<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Virtueplanet\Module\Product\Site\Helper\ProductHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app            = Factory::getApplication();
$document       = $app->getDocument();
$products       = ProductHelper::getList($params);
$currency       = CurrencyDisplay::getInstance();
$ratingModel    = VmModel::getModel('ratings');
$showCategories = $params->get('show_categories', 1);
$showRating     = $params->get('show_rating', 1) && $ratingModel->showRating();
$showPrice      = $params->get('show_price', 1);
$showShortDesc  = $params->get('show_short_desc', 1);
$showAddToCart  = $params->get('show_addtocart', 1);

if (!empty($products)) {
    require ModuleHelper::getLayoutPath('mod_vpprime_product_carousel', $params->get('layout', 'default'));
}
