<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;

$title       = $item->anchor_title ? ' title="' . $item->anchor_title . '"' : '';
$anchor_css  = 'mod-offcanvas-menu--item-anchor';
$anchor_css .= $item->anchor_css ? ' ' . $item->anchor_css : '';
$linktype    = '<span class="mod-offcanvas-menu--item-title">' . $item->title . '</span>';

if ($item->menu_icon) {
    // The link is an icon
    if ($itemParams->get('menu_text', 1)) {
        // If the link text is to be displayed, the icon is added with aria-hidden
        $linktype = '<span class="mod-offcanvas-menu--item-icon ' . $item->menu_icon . '" aria-hidden="true"></span><span class="mod-offcanvas-menu--item-title">' . $item->title . '</span>';
    } else {
        // If the icon itself is the link, it needs a visually hidden text
        $linktype = '<span class="mod-offcanvas-menu--item-icon ' . $item->menu_icon . '" aria-hidden="true"></span><span class="visually-hidden">' . $item->title . '</span>';
    }
} elseif ($item->menu_image) {
    // The link is an image, maybe with its own class
    $image_attributes = [];

    $image_attributes['class'] = 'mod-offcanvas-menu--item-image';

    if ($item->menu_image_css) {
        $image_attributes['class'] .= ' ' . $item->menu_image_css;
    }

    $linktype = HTMLHelper::_('image', $item->menu_image, $item->title, $image_attributes);

    if ($itemParams->get('menu_text', 1)) {
        $linktype .= '<span class="mod-offcanvas-menu--item-title mod-offcanvas-menu--image-title">' . $item->title . '</span>';
    }
}

if ($item->menu_level > 1) {
    $linktype = '<span class="mod-offcanvas-menu--item-indent" aria-hidden="true">' . str_repeat('<i class="mod-offcanvas-menu--spacer"></i>', ($item->menu_level - 1)) . '</span>' . $linktype;
}

$linktype = '<span class="mod-offcanvas-menu--item-inner">' . $linktype . '</span>';

if ($item->deeper) {
    $linktype .= '<span class="mod-offcanvas-menu--item-sub-opener" aria-hidden="true"><i class="fas fa-chevron-right"></i></span>';
}
?>
<span class="mod-offcanvas-menu--separator <?php echo $anchor_css; ?>"<?php echo $title; ?>><?php echo $linktype; ?></span>
