<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $app->getDocument()->getWebAssetManager();

$wa->registerAndUseScript('mod_vpprime_offcanvas_menu', 'mod_vpprime_offcanvas_menu/menu.min.js', ['version' => 'v1.0'], ['defer' => true]);
$wa->registerAndUseStyle('mod_vpprime_offcanvas_menu', 'mod_vpprime_offcanvas_menu/menu.min.css', ['version' => 'v1.0']);

$id = '';

if ($tagId = $params->get('tag_id', '')) {
    $id = ' id="' . $tagId . '"';
}
?>
<ul<?php echo $id; ?> class="mod-offcanvas-menu<?php echo $class_sfx ? ' ' . $class_sfx : ''; ?>">
<?php foreach ($list as $i => &$item) {
    $itemParams      = $item->getParams();
    $class           = 'mod-offcanvas-menu--item item-' . $item->id;

    if ($item->id == $default_id) {
        $class .= ' mod-offcanvas-menu--default';
    }

    if ($item->id == $active_id || ($item->type === 'alias' && $itemParams->get('aliasoptions') == $active_id)) {
        $class .= ' mod-offcanvas-menu--current';
    }

    if (in_array($item->id, $path)) {
        $class .= ' mod-offcanvas-menu--active';
    } elseif ($item->type === 'alias') {
        $aliasToId = $itemParams->get('aliasoptions');

        if (count($path) > 0 && $aliasToId == $path[count($path) - 1]) {
            $class .= ' mod-offcanvas-menu--active';
        } elseif (in_array($aliasToId, $path)) {
            $class .= ' mod-offcanvas-menu--alias-parent-active';
        }
    }

    if ($item->type === 'separator') {
        $class .= ' mod-offcanvas-menu--divider';
    }

    if ($item->deeper) {
        $class .= ' mod-offcanvas-menu--deeper';
    }

    if ($item->parent) {
        $class .= ' mod-offcanvas-menu--parent';
    }

    $class .= ' mod-offcanvas-menu--level-' . $item->menu_level;

    echo '<li class="' . trim($class) . '">';

    switch ($item->type) :
        case 'separator':
        case 'component':
        case 'heading':
        case 'url':
        case 'vmcategory':
            require ModuleHelper::getLayoutPath('mod_vpprime_offcanvas_menu', 'default_' . $item->type);
            break;
        default:
            require ModuleHelper::getLayoutPath('mod_vpprime_offcanvas_menu', 'default_url');
            break;
    endswitch;

    // The next item is deeper.
    if ($item->deeper) {
        echo '<ul class="mod-offcanvas-menu--sub">';
    } elseif ($item->shallower) {
        // The next item is shallower.
        echo '</li>';
        echo str_repeat('</ul></li>', $item->level_diff);
    } else {
        // The next item is on the same level.
        echo '</li>';
    }
}
?></ul>
