<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Session\Session;

defined('_JEXEC') or die;

$idTag = '#modMinicart-' . $module->id;

if ($document->getType() === 'html') {
    vmJsApi::jQuery();
    vmJsApi::jPrice();

    $options = [
        'id'             => $module->id,
        'selector'       => $idTag,
        'itemid'         => $itemid,
        'token'          => Session::getFormToken(),
        'delayedLoading' => (bool) $params->get('delay_loading', 1),
        'reloadPage'     => $isCartPage
    ];

    $scriptOptions = $document->getScriptOptions('vpprime.minicart');

    if (empty($scriptOptions) || !is_array($scriptOptions)) {
        $scriptOptions = [];
    }

    $scriptOptions[] = $options;

    $document->addScriptOptions('vpprime.minicart', $scriptOptions, false);

    $document->getWebAssetManager()
        ->useScript('core')
        ->useScript('bootstrap.offcanvas');

    $document->getWebAssetManager()
        ->registerAndUseScript('mod_vpprime_minicart', 'mod_vpprime_minicart/module.min.js', ['version' => 'v1.5'], ['defer' => true])
        ->registerAndUseStyle('mod_vpprime_minicart', 'mod_vpprime_minicart/module.min.css', ['version' => 'v1.5']);
}

$class_sfx = $active ? ' show' : '';
?>
<div id="modMinicart-<?php echo $module->id; ?>" class="mod-minicart<?php echo $moduleclass_sfx ? ' ' . $moduleclass_sfx : ''; ?>">
    <div class="mod-minicart__inner">
        <div class="mod-minicart__anchor">
            <?php if ($params->get('show_product_list', 1)) : ?>
                <a class="d-inline-block link-inherit-color btn-icon" data-bs-toggle="offcanvas" href="#miniCartOffcanvas<?php echo $module->id; ?>" role="button" aria-controls="miniCartOffcanvas<?php echo $module->id; ?>" title="<?php echo vmText::_('COM_VIRTUEMART_CART_TITLE'); ?>">
                    <span class="jewel-group">
                        <i class="vpi vpi-shopping-bag vpi-lg d-inline-block align-middle" aria-hidden="true"></i>
                        <span class="visually-hidden"><?php echo vmText::_('COM_VIRTUEMART_CART_TITLE'); ?></span>
                        <span class="mod-minicart__product-count jewel">
                            <?php echo (int) $product_count ?>
                        </span>
                    </span>
                    <span class="mod-minicart__cart-subtotal py-1 ps-1 ms-2 align-middle">
                        <?php echo $currency->priceDisplay($cart->cartPrices['salesPrice']); ?>
                    </span>
                </a>
            <?php else : ?>
                <a class="d-inline-block link-inherit-color btn-icon" href="<?php echo $cart_url; ?>" title="<?php echo vmText::_('COM_VIRTUEMART_CART_TITLE'); ?>">
                    <span class="jewel-group">
                        <i class="vpi vpi-shopping-bag vpi-2x d-inline-block align-middle" aria-hidden="true"></i>
                        <span class="visually-hidden"><?php echo vmText::_('COM_VIRTUEMART_CART_TITLE'); ?></span>
                        <span class="mod-minicart__product-count jewel">
                            <?php echo (int) $product_count ?>
                        </span>
                    </span>
                    <span class="mod-minicart__cart-subtotal p-1 ms-2 align-middle">
                        <?php echo $currency->priceDisplay($cart->cartPrices['salesPrice']); ?>
                    </span>
                </a>
            <?php endif; ?>
        </div>
        <?php if ($params->get('show_product_list', 1)) : ?>
            <div class="mod-minicart__offcanvas-container text-color-body">
                <div class="offcanvas offcanvas-end<?php echo $class_sfx; ?>" tabindex="-1" id="miniCartOffcanvas<?php echo $module->id; ?>" aria-labelledby="miniCartOffcanvas<?php echo $module->id; ?>-Label">
                    <div class="offcanvas-header px-3">
                        <h5 class="offcanvas-title" id="miniCartOffcanvas<?php echo $module->id; ?>-Label">
                            <?php echo vmText::_('COM_VIRTUEMART_CART_TITLE'); ?>
                        </h5>
                        <button type="button" class="btn-icon btn-hover" data-bs-dismiss="offcanvas" aria-label="Close">
                            <i class="vpi vpi-times vpi-lg" aria-hidden="true"></i>
                        </button>
                    </div>
                    <div class="mod-minicart__contents align-self-stretch overflow-hidden has-mod-loader">
                        <?php if (!empty($product_count)) : ?>
                            <div class="offcanvas-body p-0">
                                <?php foreach ($cart->products as $pkey => $product) : ?>
                                    <div class="p-3 mod-minicart__product-details">
                                        <div class="row g-3">
                                            <div class="col-3">
                                                <a href="<?php echo $product->url ?>" class="mod-minicart__product-thumbnail">
                                                    <?php echo !empty($product->images[0]) ? $product->images[0]->displayMediaThumb('', false) : ''; ?>
                                                </a>
                                            </div>
                                            <div class="col-8">
                                                <strong><?php echo HTMLHelper::link($product->url, $product->product_name, ['class' => 'link-body']); ?></strong>
                                                <?php $variants = $customfieldsModel->CustomsFieldCartDisplay($product); ?>
                                                <?php $temp = trim(strip_tags($variants)); ?>
                                                <?php if (!empty($temp)) : ?>
                                                    <div class="mod-minicart__product-variants">
                                                        <?php $variants; ?>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="d-flex flex-row flex-nowrap gap-1 mt-1">
                                                    <span class="mod-minicart__quantity text-muted">
                                                        <?php echo $product->quantity; ?>
                                                    </span>
                                                    <?php if ($params->get('show_price', 1) && $currency->_priceConfig['salesPrice'][0]) : ?>
                                                        <span class="text-muted" aria-hidden="true">&times;</span>
                                                        <div class="mod-product-price text-color-primary">
                                                            <?php echo $currency->priceDisplay($product->prices['salesPrice']); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="col-1">
                                                <button type="button" class="mod-minicart__remove btn-remove" aria-label="<?php echo vmText::_('COM_VIRTUEMART_CART_DELETE'); ?>" data-vpprime-minicart="remove" data-vpprime-minicart-pkey="<?php echo $pkey; ?>" data-vpprime-minicart-itemid="<?php echo $itemid; ?>" data-vpprime-minicart-active="<?php echo $idTag; ?>" data-vpprime-minicart-mid="<?php echo $module->id ?>">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="d-flex flex-column">
                                <?php if ($params->get('show_price', 1)) : ?>
                                    <div class="d-flex gap-3 justify-content-between align-items-center mod-minicart__cart-total fs-5 fw-bold p-3">
                                        <strong><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_PRICES_TOTAL'); ?></strong>
                                        <span class="mod-minicart__subtotal text-color-primary">
                                            <?php echo $currency->priceDisplay($cart->cartPrices['salesPrice']); ?>
                                        </span>
                                    </div>
                                <?php endif; ?>
                                <div class="mod-minicart__show-cart px-3 py-4">
                                    <a href="<?php echo $cart_url; ?>" class="btn btn-primary w-100">
                                        <?php echo $cartText; ?>
                                    </a>
                                </div>
                            </div>
                        <?php else : ?>
                            <div class="mod-minicart__empty-cart d-flex flex-column justify-content-center align-items-center text-center py-5 px-3">
                                <div class="empty-cart-icon text-center">
                                    <i class="fas fa-shopping-cart" aria-hidden="true" tabindex="-1"></i>
                                </div>
                                <p class="empty-cart-heading text-center">
                                    <?php echo Text::_('TPL_VP_NEOTERIC_EMPTY_CART_HEADING'); ?>
                                </p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>