<?php

/**
 * @package VP Prime Framework
 *
 * @author    Abhishek Das <info@virtueplanet.com>
 * @link      https://www.virtueplanet.com
 * @copyright Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license   GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;

defined('_JEXEC') or die;

if (!class_exists('ModVpprimeMinicartHelper')) {
    include_once __DIR__ . '/helper.php';
}

/**
 * @var \Joomla\CMS\Application\SiteApplication $app 
 */
$app                       = Factory::getApplication();
$document                  = $app->getDocument();
$cart                      = ModVpprimeMinicartHelper::getCart($params);
$product_count             = ModVpprimeMinicartHelper::getProductCount($params);
$unique_product_count      = ModVpprimeMinicartHelper::getUniqueProductCount($params);
list($cartText, $cart_url) = ModVpprimeMinicartHelper::getCartLink($params);
$currency                  = CurrencyDisplay::getInstance();
$customfieldsModel         = VmModel::getModel('Customfields');
$itemid                    = $app->input->getInt('Itemid', 0);
$aid                       = $app->input->getInt('aid', 0);
$active                    = $aid > 0 && $aid === $module->id;
$moduleclass_sfx           = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8');
$isCartPage                = strtolower(vRequest::getVar('option', '',)) === 'com_virtuemart' && strtolower(vRequest::getVar('view', '')) === 'cart';

if (!$isCartPage) {
    $menus = $app->getMenu();
    $activeMenu = $menus->getActive();

    if ($activeMenu) {
        $option = $activeMenu->query['option'] ?? '';
        $view = $activeMenu->query['view'] ?? '';

        $isCartPage = strtolower($option) === 'com_virtuemart' && strtolower($view) === 'cart';
    }
}

if (!empty($cart)) {
    include ModuleHelper::getLayoutPath('mod_vpprime_minicart', $params->get('layout', 'default'));
}
