<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;

$title           = $item->anchor_title ? ' title="' . $item->anchor_title . '"' : '';
$anchor_css      = 'mod-megamenu--item-anchor';
$anchor_css     .= $item->anchor_css ? ' ' . $item->anchor_css : '';
$showdesc        = $itemParams->get('megamenu_showdesc', 1);
$desc            = $itemParams->get('megamenu_desc', '');
$stickyText      = $itemParams->get('megamenu_sticky_text', '');
$stickyTextBg    = $itemParams->get('megamenu_sticky_text_background', '#ff0000');
$stickyTextColor = $itemParams->get('megamenu_sticky_text_color', '#ffffff');
$sticker         = '';

if (!empty($stickyText) && trim($stickyText) !== '') {
    $stickerStyle  = '--megamenu-sticker-background: ' . $stickyTextBg . ';';
    $stickerStyle .= ' --megamenu-sticker-color: ' . $stickyTextColor . ';';

    $sticker = '<span class="mod-megamenu--sticker" style="' . $stickerStyle . '" aria-hidden="true">' . $stickyText . '</span>';
}

$linktype = '<span class="mod-megamenu--item-title">' . $item->title . '</span>';

if ($item->menu_icon) {
    // The link is an icon
    if ($itemParams->get('menu_text', 1)) {
        // If the link text is to be displayed, the icon is added with aria-hidden
        $linktype = '<span class="mod-megamenu--item-icon ' . $item->menu_icon . '" aria-hidden="true"></span><span class="mod-megamenu--item-title">' . $item->title . '</span>';
    } else {
        // If the icon itself is the link, it needs a visually hidden text
        $linktype = '<span class="mod-megamenu--item-icon ' . $item->menu_icon . '" aria-hidden="true"></span><span class="visually-hidden">' . $item->title . '</span>';
    }
} elseif ($item->menu_image) {
    // The link is an image, maybe with its own class
    $image_attributes = [];

    $image_attributes['class'] = 'mod-megamenu--item-image';

    if ($item->menu_image_css) {
        $image_attributes['class'] .= ' ' . $item->menu_image_css;
    }

    $linktype = HTMLHelper::_('image', $item->menu_image, $item->title, $image_attributes);

    if ($itemParams->get('menu_text', 1)) {
        $linktype .= '<span class="mod-megamenu--item-title mod-megamenu--image-title">' . $item->title . '</span>';
    }
}

$linktype = '<span class="mod-megamenu--item-inner">' . $linktype . $sticker . '</span>';

if ($showdesc && !empty($desc) && trim($desc) !== '') {
    $linktype .= '<span class="mod-megamenu--item-desc">' . $desc . '</span>';
}
?>
<span class="mod-megamenu--heading <?php echo $anchor_css; ?>"<?php echo $title; ?>><?php echo $linktype; ?></span>
