<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $app->getDocument()->getWebAssetManager();

$wa->registerAndUseScript('mod_vpprime_mega_menu', 'mod_vpprime_mega_menu/menu.min.js', ['version' => 'v1.3'], ['defer' => true]);
$wa->registerAndUseStyle('mod_vpprime_mega_menu', 'mod_vpprime_mega_menu/menu.min.css', ['version' => 'v1.3']);

$id = '';

if ($tagId = $params->get('tag_id', '')) {
    $id = ' id="' . $tagId . '"';
}
?>
<ul<?php echo $id; ?> class="mod-megamenu<?php echo $class_sfx ? ' ' . $class_sfx : ''; ?>">
<?php foreach ($list as $i => &$item) {
    $itemParams = $item->getParams();
    $class      = 'mod-megamenu--item item-' . $item->id;

    if ($item->id == $default_id) {
        $class .= ' mod-megamenu--default';
    }

    if ($item->id == $active_id || ($item->type === 'alias' && $itemParams->get('aliasoptions') == $active_id)) {
        $class .= ' mod-megamenu--current';
    }

    if ($item->id == 191) {
        //vp_dump($active_id);
        //exit;
    }

    if (in_array($item->id, $path)) {
        $class .= ' mod-megamenu--active';
    } elseif ($item->type === 'alias') {
        $aliasToId = $itemParams->get('aliasoptions');

        if (count($path) > 0 && $aliasToId == $path[count($path) - 1]) {
            $class .= ' mod-megamenu--active';
        } elseif (in_array($aliasToId, $path)) {
            $class .= ' mod-megamenu--alias-parent-active';
        }
    }

    if ($item->type === 'separator') {
        $class .= ' mod-megamenu--divider';
    }

    if ($item->deeper) {
        $class .= ' mod-megamenu--deeper';
    }

    if ($item->parent) {
        $class .= ' mod-megamenu--parent';
    }

    if ($item->group && $item->menu_level > 1) {
        $class .= ' mod-megamenu--group';
    } else {
        $class .= ' mod-megamenu--expand';
    }

    $class .= ' mod-megamenu--level-' . $item->menu_level;

    $containerAttribs = ' data-mmm-drop-width="' . $item->dropdown_width . '"';

    if ($item->dropdown_width === 'custom') {
        $containerAttribs .= ' data-mmm-custom-width="' . $item->dropdown_custom_width . '"';
        $containerAttribs .= ' style="width: ' . $item->dropdown_custom_width . 'px;"';
    }

    $containerClass  = 'mod-megamenu--container mod-megamenu--width-' . $item->dropdown_width;
    $containerClass .= ' mod-megamenu--level-' . $item->menu_level;

    $subCssStyle  = '--megamenu-item-direction: ' . $item->direction . ';';
    $subCssStyle .= ' --megamenu-template-rows: ' . $item->template_rows . ';';
    $subCssStyle .= ' --megamenu-template-columns: ' . $item->template_columns . ';';

    if ($item->column_width === 'auto') {
        $subCssStyle .= ' --megamenu-column-width: ' . $item->column_width . ';';
    } else {
        $subCssStyle .= ' --megamenu-column-width: ' . $item->column_width . 'px;';
    }

    echo '<li class="' . trim($class) . '">';

    switch ($item->type) :
        case 'separator':
        case 'component':
        case 'heading':
        case 'url':
        case 'vmcategory':
        case 'module':
            require ModuleHelper::getLayoutPath('mod_vpprime_mega_menu', 'default_' . $item->type);
            break;
        default:
            require ModuleHelper::getLayoutPath('mod_vpprime_mega_menu', 'default_url');
            break;
    endswitch;

    // The next item is deeper.
    if ($item->deeper) {
        echo '<div class="' . $containerClass . '"' . $containerAttribs . '>';
        echo '<ul class="mod-megamenu--sub" style="' . $subCssStyle . '">';
    } elseif ($item->shallower) {
        // The next item is shallower.
        echo '</li>';
        echo str_repeat('</ul></div></li>', $item->level_diff);
    } else {
        // The next item is on the same level.
        echo '</li>';
    }
}
?></ul>
