<?php

/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\GlobalHelper;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa           = $app->getDocument()->getWebAssetManager();
$idTag        = 'PrimeManufacturerCarousel-' . $module->id;
$globalHelper = GlobalHelper::getInstance();

if ($wa->assetExists('preset', 'tiny-slider')) {
    $wa->usePreset('tiny-slider');
} else {
    $wa->registerAndUseScript('mod_vpprime_slider.tiny-slider', 'mod_vpprime_slider/tiny-slider.min.js', ['version' => 'v2.9.3'], ['defer' => true]);
    $wa->registerAndUseStyle('mod_vpprime_slider.tiny-slider', 'mod_vpprime_slider/tiny-slider.min.css', ['version' => 'v2.9.3']);
}

$wa->useScript('core');
$wa->registerAndUseScript('mod_vpprime_manufacturer_carousel', 'mod_vpprime_manufacturer_carousel/module.min.js', ['version' => 'v1.1'], ['defer' => true]);

$options = [
    'container'            => '#' . $idTag,
    'loop'                 => false,
    'mouseDrag'            => false,
    'slideBy'              => 'page',
    'gutter'               => (float) $params->get('gutter', 28),
    'speed'                => (int) $params->get('speed', 300),
    'rewind'               => true,
    'autoplay'             => (bool) $params->get('autoplay', 1),
    'autoplayHoverPause'   => true,
    'autoplayButtonOutput' => false,
    'autoplayTimeout'      => (int) $params->get('autoplayTimeout', 5000),
    'lazyload'             => (bool) $params->get('lazyload', 1),
    'controls'             => (bool) $params->get('controls', 1),
    'controlsText'         => [
        '<i class="vpi vpi-chevron-left" aria-hidden="true"></i><span class="visually-hidden">Prev</span>',
        '<i class="vpi vpi-chevron-right" aria-hidden="true"></i><span class="visually-hidden">Next</span>'
    ],
    'nav'                  => (bool) $params->get('nav', 0),
    'navPosition'          => $params->get('navPosition', 'bottom'),
    'items'                => (int) $params->get('items', 3),
    'responsive'           => [
        576 => [
            'items' => (int) $params->get('itemsSm', 4)
        ],
        768 => [
            'items' => (int) $params->get('itemsMd', 6)
        ],
        992 => [
            'items' => (int) $params->get('itemsLg', 8)
        ]
    ]
];

$configs = $globalHelper->getData('vpprime.manufacturer.carousel', []);

if (empty($configs) || !is_array($configs)) {
    $configs = [];
}

$key           = (int) $module->id;
$configs[$key] = $options;

$globalHelper->setData('vpprime.manufacturer.carousel', $configs);

$document->addScriptOptions('vpprime.manufacturer.carousel', array_values($configs), false);

$linkType    = $params->get('linkType', 'listing');
$lazyLoad    = $params->get('lazyload', 1);
$imageClass  = $lazyLoad ? 'manufacturer-thumbnail tns-lazy-img' : 'manufacturer-thumbnail';
$imageClass .= $params->get('grayScaleEffect', 1) ? ' gray-scale-effect' : '';
$url         = 'index.php?option=com_virtuemart&view=manufacturer&virtuemart_manufacturer_id=%s';

if ($linkType === 'listing') {
    $url = 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=%s';
}
?>
<div id="<?php echo $idTag; ?>" class="vpprime-manufacturer-carousel tns-initial-container">
    <?php foreach ($items as $item) : ?>
        <div class="vpprime-manufacturer text-center">
            <?php if ($linkType === 'none') : ?>
                <?php echo VirtuemartHelper::prepareLazyImageHTML($item->images[0]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad); ?>
            <?php else : ?>
                <a href="<?php echo Route::_(sprintf($url, $item->virtuemart_manufacturer_id)); ?>" class="d-block text-center">
                    <?php echo VirtuemartHelper::prepareLazyImageHTML($item->images[0]->displayMediaThumb(['class' => $imageClass], false), $lazyLoad); ?>
                </a>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
</div>
