<?php

/**
 * @package     VP Prime Ajax Product Search
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2023 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Router\Route;
use Virtueplanet\Plugin\System\Prime\Helper\VirtuemartHelper;

defined('_JEXEC') or die;

$unitDesc = vmText::sprintf('COM_VIRTUEMART_PRODUCT_UNITPRICE', vmText::_('COM_VIRTUEMART_UNIT_SYMBOL_' . $product->product_unit));
$url      = Route::_(VirtuemartHelper::getProductUrl($product));
?>
<div class="searched-product">
    <?php if ($params->get('show_images', 1) && !empty($product->images[0])) : ?>
        <div class="searched-product-image">
            <a href="<?php echo $url; ?>">
                <?php echo $product->images[0]->displayMediaThumb('class="img-responsive"', false); ?>
            </a>
        </div>
    <?php endif; ?>
    <div class="searched-product-info">
        <div class="searched-product-info-inner">
            <div class="searched-product-title">
                <a href="<?php echo $url; ?>" class="link-body"><?php echo $product->product_name; ?></a>
            </div>
            <?php if ($params->get('show_category', 1) && !empty($product->categoryNames)) : ?>
                <div class="searched-product-category text-muted"><?php echo implode(', ', $product->categoryNames); ?></div>
            <?php endif; ?>
            <?php if ($params->get('show_price', 1)) : ?>
                <?php if ($product->prices['salesPrice'] <= 0 && VmConfig::get('askprice', 1) && isset($product->images[0]) && !$product->images[0]->file_is_downloadable) : ?>
                    <?php $ask_url = Route::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id, false); ?>
                    <a class="btn btn-info btn-sm" href="<?php echo $url; ?>"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_ASKPRICE'); ?></a>
                <?php else : ?>
                    <div class="searched-product-price">
                        <?php if ($priceType == 'unitPrice') : ?>
                            <?php echo $currency->createPriceDiv('unitPrice', $unitDesc, $product->prices); ?>
                        <?php else : ?>
                            <?php echo $currency->createPriceDiv($priceType, '', $product->prices); ?>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
    <a href="<?php echo $url; ?>" class="searched-product-overlay" aria-label="<?php echo htmlspecialchars($product->product_name, ENT_QUOTES, 'UTF-8'); ?>"></a>
</div>