<?php

/**
 * @package     VP Prime Ajax Product Search
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2023 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Language\Text;

defined('_JEXEC') or die;

/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $app->getDocument()->getWebAssetManager();

$wa->useScript('jquery');
$wa->registerAndUseScript('mod_vpprime_ajax_search', 'mod_vpprime_ajax_search/search.min.js', ['version' => 'v1.0'], ['defer' => true]);
$wa->registerAndUseStyle('mod_vpprime_ajax_search', 'mod_vpprime_ajax_search/search.min.css', ['version' => 'v1.0']);

$wa->addInlineStyle("
.vpprimeajaxsearch-suggestion {
    width: {$width_desktop}%;
}
@media (min-width: 992px) and (max-width: 1200px) {
    .vpprimeajaxsearch-suggestion {
        width: {$width_sm_desktop}%;
    }
}
@media(min-width: 768px) and (max-width: 991px) {
    .vpprimeajaxsearch-suggestion {
        width: {$width_tablet}%;
    }
}
@media(max-width: 767px) {
    .vpprimeajaxsearch-suggestion {
        width: {$width_mobile}%;
    }
}
");

$attribs = [
    'class' => 'form-select form-select-search'
];
?>
<div class="mod-vpprime-ajax-search<?php echo $moduleclass_sfx ? ' ' . $moduleclass_sfx : ''; ?>">
    <form action="<?php echo $action_url; ?>" data-action="<?php echo $ajax_action_url; ?>" method="get">
        <label for="mod-vpprime-ajax-search__keyword-<?php echo $module->id; ?>" class="visually-hidden"><?php echo $text; ?></label>
        <div class="input-group">
            <input type="search" name="keyword" id="mod-vpprime-ajax-search__keyword-<?php echo $module->id; ?>" class="form-control search-query input-lg" value="" placeholder="<?php echo $text; ?>" autocomplete="off" spellcheck="false" data-ajaxsearch="true" data-foundtext="<?php echo $found_text; ?>" data-viewalltext="<?php echo $viewall_text; ?>" data-limit="<?php echo $limit; ?>" data-catid="<?php echo $category_id; ?>" data-minchars="<?php echo $min_characters; ?>" />
            <button type="submit" class="btn btn-primary" aria-label="<?php echo Text::_('JSEARCH_FILTER'); ?>">
                <i class="vpi vpi-search fa-lg vpprime-ajax-search-btn-icon" aria-hidden="true"></i>
                <i class="fa fa-spinner fa-spin fa-lg vpprime-ajax-search-btn-loading-icon" aria-hidden="true"></i>
            </button>
        </div>
        <?php foreach ($hidden_fields as $name => $value) : ?>
            <input type="hidden" name="<?php echo $name; ?>" value="<?php echo $value; ?>" />
        <?php endforeach; ?>
    </form>
</div>