<?php

/**
 * @package     VP Prime Ajax Product Search
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2012-2023 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Virtueplanet\Module\AjaxSearch\Site\Helper\SearchHelper;

defined('_JEXEC') or die;

/** @var \Joomla\CMS\Application\SiteApplication $app */
$app              = Factory::getApplication();
$doc              = $app->getDocument();
$Itemid           = $app->input->getInt('Itemid', 0);
$ajax_action_url  = Route::_('index.php?option=com_ajax&module=vpprime_ajax_search&method=get&format=json&mid=' . $module->id . 'Itemid=' . $Itemid);
$category_id      = SearchHelper::getCategoryId($params);
$action_url       = Route::_('index.php?option=com_virtuemart&view=category&search=true&limitstart=0&virtuemart_category_id=' . $category_id);
$text             = htmlspecialchars($params->get('text', Text::_('MOD_VPPRIME_AJAX_SEARCH_SEARCHBOX_TEXT')), ENT_COMPAT, 'UTF-8');
$moduleclass_sfx  = htmlspecialchars($params->get('moduleclass_sfx', ''), ENT_COMPAT, 'UTF-8');
$found_text       = htmlspecialchars($params->get('found_text', Text::_('MOD_VPPRIME_AJAX_SEARCH_PRODUCTS_FOUND_TEXT')), ENT_COMPAT, 'UTF-8');
$viewall_text     = htmlspecialchars($params->get('viewall_text', Text::_('MOD_VPPRIME_AJAX_SEARCH_VIEWALL_TEXT')), ENT_COMPAT, 'UTF-8');
$limit            = SearchHelper::getValidNumber($params, 'limit', 12);
$hidden_fields    = SearchHelper::getHiddenFields($params, $action_url);
$width_desktop    = SearchHelper::getWidthPerRow($params, 'items_per_row_desktop', 2);
$width_sm_desktop = SearchHelper::getWidthPerRow($params, 'items_per_row_desktop_small', 2);
$width_tablet     = SearchHelper::getWidthPerRow($params, 'items_per_row_tablet', 1);
$width_mobile     = SearchHelper::getWidthPerRow($params, 'items_per_row_mobile', 1);
$currency         = CurrencyDisplay::getInstance();
$show_loader      = (int) $params->get('show_loader', 1);
$min_characters   = (int) $params->get('min_characters', 2);

require ModuleHelper::getLayoutPath('mod_vpprime_ajax_search', $params->get('layout', 'default'));
