<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

// Load VirtueMart Config and language
VmConfig::loadConfig();

// Load VirtueMart Languge
VmConfig::loadJLang('com_virtuemart', true);

// Register site helper
JLoader::register('VMEssentialsHelpersVMEssentials', VMESSENTIALS_SITE . '/helpers/vmessentials.php');

// Register utility helper
JLoader::register('VMEssentialsHelperUtility', VMESSENTIALS_SITE . '/helpers/utility.php');

// Register route helper
JLoader::register('VMEssentialsHelperRoute', VMESSENTIALS_SITE . '/helpers/route.php');

abstract class ModVMEWishlistHelper
{
	public static function getAjax()
	{
		if (JModuleHelper::isEnabled('mod_vme_wishlist'))
		{
			if ($module = JModuleHelper::getModule('mod_vme_wishlist'))
			{
				$html   = JModuleHelper::renderModule($module);
				$output = array('html' => $html);
				
				return VMEssentialsHelperUtility::jsonReturn($output);
			}
		}
	}
	
	public static function getProducts()
	{
		$model       = VMEssentialsHelpersVMEssentials::getModel('Wishlist');
		$products    = array();
		$product_ids = $model->getAllItemIds();
		
		if (!empty($product_ids) && is_array($product_ids))
		{
			$model             = VmModel::getModel('Product');
			$ratingModel       = VmModel::getModel('ratings');
			$model->withRating = $ratingModel->showRating();
			$products          = $model->getProducts($product_ids);
			
			// Add product image
			$model->addImages($products, 1);
		}
		
		return $products;
	}
}
