<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;
?>
<div class="vme-mod-compare <?php echo $class_sfx ?>">
	<div class="vmessentials-wrapper vme-mod-container">
		<div class="vme-mod-inner">
			<div class="vme-mod-contents">
				<?php if (empty($count)) : ?>
					<div class="vme-mod-header empty">
						<div class="vme-row vme-row-mini">
							<div class="vme-column vme-align-center">
								<?php echo JText::_('MOD_VME_COMPARE_EMPTY_COMPARE'); ?>
							</div>
						</div>
					</div>
				<?php else : ?>
					<div class="vme-mod-header">
						<div class="vme-row vme-row-mini">
							<div class="vme-column">
								<span class="vme-count-text"><?php echo JText::plural('MOD_VME_COMPARE_N_PRODUCTS', $count); ?></span>
								<?php if (!empty($url)) : ?>
									<a class="btn-vme-text vme-pull-right" href="<?php echo $url ?>" title="<?php echo JText::_('MOD_VME_COMPARE_COMPARE') ?>"><?php echo JText::_('MOD_VME_COMPARE_COMPARE') ?></a>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<?php foreach ($products as $key => $product) : ?>
						<div class="vme-row vme-row-mini vme-product-row">
							<div class="vme-column vme-mod-col-1">
								<a href="<?php echo JRoute::_($product->link) ?>" class="product-thumbnail">
									<?php echo !empty($product->images[0]) ? $product->images[0]->displayMediaThumb('', false) : ''; ?>
								</a>
							</div>
							<div class="vme-column vme-mod-col-2">
								<?php echo JHtml::link(JRoute::_($product->link), $product->product_name, 'class="mod-product-name hover-invert"'); ?>
								<?php if ($params->get('show_price', 1) && $currency->_priceConfig['salesPrice'][0]) : ?>
								<div class="mod-product-price">
									<?php echo $currency->priceDisplay($product->prices['salesPrice']); ?>
								</div>
								<?php endif; ?>
							</div>
							<div class="vme-column vme-mod-col-3">
								<form action="<?php echo JRoute::_('index.php?option=com_vmessentials&view=compare') ?>" method="post" class="vmessentials-form">
									<button type="submit" class="vme-remove-btn" title="<?php echo JText::_('MOD_VME_COMPARE_REMOVE') ?>"<?php echo $use_ajax ? ' data-vmecompareremove' : ''; ?>>
										<span aria-hidden="true">&times;</span><span class="vme-sr-only"><?php echo JText::_('MOD_VME_COMPARE_REMOVE') ?></span>
									</button>
									<input type="hidden" name="option" value="com_vmessentials" />
									<input type="hidden" name="task" value="compare.remove" />
									<input type="hidden" name="virtuemart_product_id" value="<?php echo (int) $product->virtuemart_product_id; ?>" />
									<input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>" />
									<?php echo JHtml::_('form.token'); ?>
									<?php echo JHtml::_('vmessentials.returnUri'); ?>
								</form>
							</div>
						</div>
						<?php if (($key + 1) != $count) : ?>
							<div class="vme-mod-row-separator"></div>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>
				<div class="vme-mod-loader vme-hide" aria-hidden="true"></div>
				<div class="vme-mod-loader-wheel vme-hide" aria-hidden="true"></div>
			</div>
		</div>
	</div>
</div>
