<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

if (!defined('VMESSENTIALS_ADMINISTRATOR'))
{
	return '';
}

// Register helper class
JLoader::register('ModVMECompareHelper', __DIR__ . '/helper.php');

$app       = JFactory::getApplication();
$input     = $app->input;
$products  = ModVMECompareHelper::getProducts();
$Itemid    = $input->getInt('Itemid', 0);
$url       = JRoute::_(VMEssentialsHelperRoute::getRoute('compare'));
$count     = count($products);
$currency  = CurrencyDisplay::getInstance();
$class_sfx = htmlspecialchars($params->get('moduleclass_sfx', ''));
$option    = strtolower($input->getCmd('option', ''));
$view      = strtolower($input->getCmd('view', ''));
$use_ajax  = ($option == 'com_vmessentials' && $view == 'compare') ? false : true;

JHtml::addIncludePath(VMESSENTIALS_SITE . '/helpers/html');

require JModuleHelper::getLayoutPath('mod_vme_compare', $params->get('layout', 'default'));
