/*
 * @package     VP Neoteric
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
**/

var GLightboxHelper = window.GLightboxHelper || {};

(function (helper, GLightbox, document) {
    helper.linkInstance = null;
    helper.linkSelector = '[data-glightbox-link]';
    helper.resizeTimeout = null;
    helper.fixedPositions = '.fixed-top, .fixed-bottom, .is-fixed';

    helper.setContainerHeight = function () {
        var body = document.getElementById('glightbox-body');

        if (!body || !body.classList.contains('modal-link')) {
            return false;
        }

        var container = body.querySelector('.ginner-container');

        if (container) {
            var iframe = container.querySelector('iframe');

            if (iframe) {
                container.style.height = '10000px';

                var contentHeight = iframe.contentWindow.document.body.offsetHeight;
                var viewportHeight = window.innerHeight;

                if (contentHeight <= (viewportHeight * 0.95)) {
                    container.style.height = contentHeight + 'px';
                } else {
                    container.style.height = '90vh';
                }

                container.style.minHeight = '350px';
            }
        }

        var wrapper = body.querySelector('.gslide-external');

        if (wrapper) {
            wrapper.classList.remove('iframe-loading');
        }
    }

    helper.showIframeLoader = function () {
        var body = document.getElementById('glightbox-body');

        if (!body || !body.classList.contains('modal-link')) {
            return false;
        }

        var wrapper = body.querySelector('.gslide-external');

        if (wrapper) {
            if (!wrapper.querySelector('.iframe-loader')) {
                var loader = document.createElement('div');

                loader.classList.add('iframe-loader');
                loader.innerHTML = '<div class="iframe-spinner"></div>';

                wrapper.appendChild(loader);
            }

            wrapper.classList.add('iframe-loading');
        }
    }

    helper.getScrollbarWidth = function () {
        // Creating invisible container
        var outer = document.createElement('div');
        outer.style.visibility = 'hidden';
        outer.style.overflow = 'scroll'; // forcing scrollbar to appear
        outer.style.msOverflowStyle = 'scrollbar'; // needed for WinJS apps
        document.body.appendChild(outer);

        // Creating inner element and placing it in the container
        var inner = document.createElement('div');
        outer.appendChild(inner);

        // Calculating difference between container's full width and the child width
        var scrollbarWidth = (outer.offsetWidth - inner.offsetWidth);

        // Removing temporary elements from the DOM
        outer.parentNode.removeChild(outer);

        return scrollbarWidth;
    }

    document.addEventListener('DOMContentLoaded', function () {
        if (helper.linkInstance) {
            helper.linkInstance.destroy();
        }

        helper.linkInstance = GLightbox({
            width: '900px',
            height: '90vh',
            skin: 'clean modal-link',
            preload: false
        });

        helper.linkInstance.on('open', function () {
            var scrollBarWidth = helper.getScrollbarWidth();

            if (scrollBarWidth > 0) {
                [].slice.call(document.querySelectorAll(helper.fixedPositions)).forEach(function (element) {
                    if (window.innerWidth <= element.clientWidth + scrollBarWidth) {
                        element.style.setProperty('margin-right', scrollBarWidth + 'px');
                    }
                })
            }
        });

        helper.linkInstance.on('close', function () {
            [].slice.call(document.querySelectorAll(helper.fixedPositions)).forEach(function (element) {
                element.style.setProperty('margin-right', '');
            })
        });

        helper.linkInstance.on('slide_after_load', function () {
            helper.linkInstance.settings.openEffect = 'none';
        });

        helper.linkInstance.on('slide_after_load', helper.setContainerHeight);

        document.documentElement.addEventListener('click', function (e) {
            if (e.target && (e.target.matches(helper.linkSelector) || e.target.closest(helper.linkSelector))) {
                e.preventDefault();

                var element = e.target.closest(helper.linkSelector) ? e.target.closest(helper.linkSelector) : e.target;
                var href = typeof element.dataset.target != 'undefined' ? element.dataset.target : element.getAttribute('href');

                element.blur();

                var mouseoutEvent = new Event('mouseout');

                element.dispatchEvent(mouseoutEvent);

                helper.linkInstance.settings.openEffect = 'zoom';

                helper.linkInstance.setElements([{
                    'href': href
                }]);

                helper.linkInstance.open();
            }
        });
    });

    window.addEventListener('resize', function () {
        if (helper.resizeTimeout) {
            this.clearTimeout(helper.resizeTimeout);
        }

        helper.resizeTimeout = setTimeout(function () {
            helper.setContainerHeight();
        }, 50);
    });
})(GLightboxHelper, GLightbox, document);
