/*!
 * @package     VP Prime Framework
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023-2025 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

var SitePreview = window.SitePreview || {};

(function (app, document) {

    app.init = function () {
        var previewSection = document.querySelector('.sitepreview');
        var prevLoader = null;

        window.addEventListener('load', function () {
            prevLoader = setInterval(function () {
                if (previewSection && app.isVisible(previewSection)) {
                    var frame = document.querySelector('.sitepreview-frame');

                    if (frame) {
                        frame.setAttribute('src', frame.getAttribute('data-src'));

                        var previewMode = document.querySelector('input[name="prev_scale_to_fit"]:checked');

                        if (previewMode && previewMode.value == 1) {
                            app.previewFitToScreen();
                        } else {
                            app.previewNormal();
                        }

                        clearInterval(prevLoader);
                    }
                }
            }, 50);

        })

        app.initPreview();
    }

    app.initPreview = function () {
        document.querySelector('.sitepreview').closest('.controls').classList.add('sitepreview-control');
        document.querySelector('.sitepreview').closest('.control-group').querySelector('.control-label').remove();

        document.querySelectorAll('input[name="prev_scale_to_fit"]').forEach(function (radio) {
            radio.addEventListener('change', function () {
                if (document.querySelector('input[name="prev_scale_to_fit"]:checked').value == 1) {
                    app.previewFitToScreen();
                } else {
                    app.previewNormal();
                }
            })
        })

        document.querySelector('[data-refreshpreview]').addEventListener('click', function () {
            document.querySelector('.sitepreview-container').classList.add('sitepreviw-loading');
            document.querySelector('.sitepreview-frame').contentDocument.location.reload(true);
        })

        document.querySelector('.sitepreview-frame').addEventListener('load', function () {
            document.querySelector('.sitepreview-container').classList.remove('sitepreviw-loading');
        })
    }

    app.previewFitToScreen = function () {
        var availableWidth = document.querySelector('.sitepreview').offsetWidth;
        var displayWidth = 1400;
        var displayHeight = 1000;
        var scale = (availableWidth / displayWidth).toFixed(2);
        var containerHeight = scale * displayHeight;

        document.querySelector('.sitepreview-container').style.height = containerHeight + 'px';

        document.querySelector('.sitepreview-frame').style.cssText = app.getStyles({
            'width': displayWidth + 'px',
            'height': displayHeight + 'px',
            '-ms-zoom': scale,
            '-moz-transform': 'scale(' + scale + ')',
            '-moz-transform-origin': '0 0',
            '-o-transform': 'scale(' + scale + ')',
            '-o-transform-origin': '0 0',
            '-webkit-transform': 'scale(' + scale + ')',
            '-webkit-transform-origin': '0 0',
            'transform': 'scale(' + scale + ')',
            'transform-origin': '0 0'
        });
    }

    app.previewNormal = function () {
        document.querySelector('.sitepreview-container').style.height = '';
        document.querySelector('.sitepreview-frame').removeAttribute('style');
    }

    app.getStyles = function (obj) {
        return Object.keys(obj).map(function (key) {
            return key + ': ' + obj[key];
        }).join(';');
    }

    app.isVisible = function (elem) {
        return !!(elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length);
    }

    document.addEventListener('DOMContentLoaded', function (event) {
        app.init();
    })

})(SitePreview, document, window);
