/*!
 * @package     VP Prime Framework
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

var VirtueMartCategoryMenuModule = window.VirtueMartCategoryMenuModule || {};

(function (mmm, document) {

    mmm.topSelector = '.mod-vmcategory-menu';

    mmm.itemSelector = '.mod-vmcategory-menu--item';

    mmm.itemOpenerSelector = '.mod-vmcategory-menu--item-sub-opener';

    mmm.itemSubmenuSelector = '.mod-vmcategory-menu--sub';

    mmm.itemDeeperClassName = 'mod-vmcategory-menu--deeper';

    mmm.itemActiveClassName = 'mod-vmcategory-menu--active';

    mmm.itemOpeningClassName = 'mod-vmcategory-menu--opening';

    mmm.itemOpenClassName = 'mod-vmcategory-menu--open';

    if (typeof Element !== 'undefined') {
        if (!Element.prototype.matches) {
            Element.prototype.matches = Element.prototype.msMatchesSelector || Element.prototype.webkitMatchesSelector;
        }

        if (!Element.prototype.closest) {
            Element.prototype.closest = function (s) {
                var el = this;

                do {
                    if (el.matches(s)) return el;
                    el = el.parentElement || el.parentNode;
                } while (el !== null && el.nodeType === 1);

                return null;
            };
        }
    }

    mmm.init = function () {
        [].slice.call(document.querySelectorAll(mmm.topSelector)).forEach(function (menu) {
            mmm.initOne(menu);
        });
    }

    /**
     * Initialise one mega menu.
     *
     * @param {Element} menu 
     */
    mmm.initOne = function (menu) {
        [].slice.call(menu.querySelectorAll(mmm.itemOpenerSelector)).forEach(function (opener) {
            var item = opener.closest(mmm.itemSelector);

            if (!item) {
                return false;
            }

            if (item.classList.contains(mmm.itemDeeperClassName) && item.classList.contains(mmm.itemActiveClassName)) {
                item.classList.add(mmm.itemOpenClassName);
            }

            opener.addEventListener('click', function (event) {
                event.preventDefault();
                var item = opener.closest(mmm.itemSelector),
                    submenu = item.querySelector(':scope > ' + mmm.itemSubmenuSelector);

                submenu.item = item;
                item.classList.add(mmm.itemOpeningClassName);
                submenu.style.height = 'auto';
                var realHeight = submenu.offsetHeight;

                if (item.classList.contains(mmm.itemOpenClassName)) {
                    item.classList.remove(mmm.itemOpenClassName);
                    item.classList.remove(mmm.itemOpenClassName);
                    submenu.style.height = realHeight + 'px';

                    setTimeout(function () {
                        submenu.removeEventListener('transitionend', mmm.onClose);
                        submenu.addEventListener('transitionend', mmm.onClose);
                        submenu.style.height = '0';
                    }, 10)
                } else {
                    item.classList.add(mmm.itemOpenClassName);
                    submenu.style.height = '';

                    setTimeout(function () {
                        submenu.removeEventListener('transitionend', mmm.onOpen);
                        submenu.addEventListener('transitionend', mmm.onOpen);
                        submenu.style.height = realHeight + 'px';
                    }, 10)

                }

                return false;
            })
        });
    }

    mmm.onOpen = function (event) {
        event.currentTarget.item.classList.remove(mmm.itemOpeningClassName);
        event.currentTarget.style.height = '';
    }

    mmm.onClose = function (event) {
        event.currentTarget.item.classList.remove(mmm.itemOpeningClassName);
        event.currentTarget.style.height = '';
    }

    document.addEventListener('DOMContentLoaded', function (event) {
        mmm.init();
    })

})(VirtueMartCategoryMenuModule, document);
