/**
 * @package     VP Prime Slider
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

var Joomla = window.Joomla || {};
var PrimeSlider = window.PrimeSlider || {};

(function (module, Joomla, document) {
    module.checkRestartAutoplay = function (config, slider) {
        var info = slider.getInfo();

        setInterval(function () {
            if (slider.lastChanged && Date.now() - slider.lastChanged > config.autoplayTimeout && !info.container.matches(':hover')) {
                slider.play();
                slider.lastChanged = Date.now();
            }
        }, 500);
    }

    document.addEventListener('DOMContentLoaded', function () {
        var configs = Joomla.getOptions('vpprime.slider', []);
        var options = {
            onInit: function (info) {
                var controlsContainer = info.container.closest('.prime-slider').querySelector('.prime-slider-controls');
                var paginationContainer = info.container.closest('.prime-slider').querySelector('.prime-slider-navigation');

                if (controlsContainer) {
                    controlsContainer.classList.remove('d-none');
                }

                if (paginationContainer) {
                    paginationContainer.classList.remove('d-none');
                }
            }
        }

        if (Array.isArray(configs) && configs.length) {
            configs.forEach(function (config) {
                config = Object.assign({}, config, options);
                var slider = tns(config);

                slider.lastChanged = null;
                slider.lastIndex = null;

                slider.getInfo().slideItems[slider.getInfo().index].classList.add('tns-slide-no-transition');

                slider.events.on('indexChanged', function (info) {
                    slider.lastChanged = Date.now();

                    if (slider.lastIndex) {
                        var prevSlide = info.slideItems[slider.lastIndex];
                        var currentSlide = info.slideItems[info.index];

                        if (prevSlide.dataset.position == currentSlide.dataset.position && prevSlide.classList.contains('tns-slide-cloned')) {
                            currentSlide.classList.add('tns-slide-no-transition');
                        } else {
                            currentSlide.classList.remove('tns-slide-no-transition');
                        }

                        prevSlide.classList.remove('tns-slide-no-transition');
                    }

                    slider.lastIndex = info.index;
                });

                if (config.autoplay && !config.autoplayButtonOutput) {
                    module.checkRestartAutoplay(config, slider);
                }
            })
        }
    })
})(PrimeSlider, Joomla, document);