/**
 * @package     VP Prime Framework
 *
 * @author      Abhishek Das <info@virtueplanet.com>
 * @link        https://www.virtueplanet.com
 * @copyright   Copyright (C) 2023 Virtueplanet Services LLP. All Rights Reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

var Joomla = window.Joomla || {};
var PrimeManufacturerCarousel = window.PrimeManufacturerCarousel || {};

(function (module, Joomla, document) {
    module.checkRestartAutoplay = function (config, slider) {
        var info = slider.getInfo();

        setInterval(function () {
            if (slider.lastChanged && Date.now() - slider.lastChanged > config.autoplayTimeout && !info.container.matches(':hover')) {
                slider.play();
                slider.lastChanged = Date.now();
            }
        }, 500);
    }

    document.addEventListener('DOMContentLoaded', function () {
        var configs = Joomla.getOptions('vpprime.manufacturer.carousel', []);

        if (Array.isArray(configs) && configs.length) {
            configs.forEach(function (config) {
                var slider = tns(config);

                slider.lastChanged = null;

                slider.events.on('indexChanged', function (info) {
                    slider.lastChanged = Date.now();
                });

                if (config.autoplay && !config.autoplayButtonOutput) {
                    module.checkRestartAutoplay(config, slider);
                }
            })
        }
    })
})(PrimeManufacturerCarousel, Joomla, document);