/**
 * @package    VP Rating - Web Component
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */
class VPRating extends HTMLElement{constructor(){super(),this.attachShadow({mode:"open"})}get max(){return this._getPositiveNumberAttribute("max",5)}set max(a){this.setAttribute("max",a)}get name(){return this.getAttribute("name")}set name(a){this.setAttribute("name",a)}get rating(){return this._getPositiveNumberAttribute("rating",0)}set rating(a){this.setAttribute("rating",a)}get half(){return this._getValidBooleanAttribute("half",!1)}set half(a){this.setAttribute("half",a)}get readonly(){return this._getValidBooleanAttribute("readonly",!1)}set readonly(a){this.setAttribute("readonly",a)}get unratedMsg(){return this.getAttribute("unrated-msg")}set unratedMsg(a){this.setAttribute("unrated-msg",a)}get hint(){return this.getAttribute("hint")}set hint(a){this.setAttribute("hint",a)}get color(){return this._getValidColorAttribute("color","#000000")}set color(a){this.setAttribute("color",a)}get size(){return this._getPositiveNumberAttribute("size",0)}set size(a){this.setAttribute("size",a)}static get observedAttributes(){return["max","name","rating","half","readonly","unrated-msg","hint","color","size"]}attributeChangedCallback(){this._render()}connectedCallback(){this._render()}disconnectedCallback(){this.innerHTML=""}_render(){this.innerHTML="";const a=document.createElement("div");let b;a.classList.add("container"),this.readonly&&a.classList.add("readonly");for(let c=1;c<=this.max;c++)b=document.createElement("i"),b.classList.add("star"),b.setAttribute("aria-hidden","true"),b.setAttribute("data-rating",c),!this.readonly&&this.hint&&b.setAttribute("title",c+" "+this.hint),a.append(b);if(this.readonly).5<this.rating&&this.hint?a.setAttribute("title",this.rating+" "+this.hint):.5>this.rating&&this.unratedMsg&&a.setAttribute("title",this.unratedMsg);else if(this.name){const a=document.createElement("input");a.setAttribute("type","hidden"),a.setAttribute("name",this.name),a.setAttribute("value",this.rating),this.appendChild(a)}this.shadowRoot.innerHTML=this._getStyles(),this.shadowRoot.append(a),this._setStarRating(this.rating),this.readonly||this._bindEvents()}_setStarRating(a){const b=this.shadowRoot.querySelector(".container");let c,d=a;for(let e=0;e<this.max;e++)c=b.children[e],c.classList.remove("star-full"),c.classList.remove("star-half"),0<d&&(this.half&&1>d&&.5>=d?c.classList.add("star-half"):.5<d&&c.classList.add("star-full")),d--}_bindEvents(){this.shadowRoot.querySelector(".container").addEventListener("mouseover",this._bindMouseover.bind(this)),this.shadowRoot.querySelector(".container").addEventListener("mouseleave",this._bindMouseleave.bind(this)),this.shadowRoot.querySelector(".container").addEventListener("click",this._bindClick.bind(this))}_bindMouseover(a){if(!a.target)return!1;if(a.target.classList.contains("star")){const{rating:b}=a.target.dataset;this._setStarRating(b)}}_bindMouseleave(){this._setStarRating(this.rating)}_bindClick(a){if(!a.target)return!1;if(a.target.classList.contains("star")){const{rating:b}=a.target.dataset;this.rating=b,this._setStarRating(b);const c=this.querySelector("input[type='hidden']");c&&c.setAttribute("value",this.rating)}}_getPositiveNumberAttribute(a,b=0){let c=this.getAttribute(a);return c=c?parseFloat(c):0,c=!c||0>c?b:c,c}_getValidBooleanAttribute(a,b=!1){let c=this.getAttribute(a);return null===c&&(c=b),c="true"===c||"TRUE"===c||"1"===c,c}_getValidColorAttribute(a,b="#000000"){let c=this.getAttribute(a);const d=new Option().style;return d.color=c,""==d.color?b.replace("#","%23"):d.color.replace("#","%23")}_getStyles(){const a=`<style>.container{display:inline-block;}.star{display:inline-block;width:${this.size}px;height:${this.size}px;background-image:url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='${this.color}' viewBox='0 0 16 16'%3E%3Cpath d='M16 6.204l-5.528-0.803-2.472-5.009-2.472 5.009-5.528 0.803 4 3.899-0.944 5.505 4.944-2.599 4.944 2.599-0.944-5.505 4-3.899zM8 11.773l-3.492 1.836 0.667-3.888-2.825-2.753 3.904-0.567 1.746-3.537 1.746 3.537 3.904 0.567-2.825 2.753 0.667 3.888-3.492-1.836z'%3E%3C/path%3E%3C/svg%3E%0A");background-repeat:no-repeat;background-color:transparent;background-position:50% 50%;background-size:contain;margin-right:2px;}.star-full{background-image:url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='${this.color}' viewBox='0 0 16 16'%3E%3Cpath d='M16 6.204l-5.528-0.803-2.472-5.009-2.472 5.009-5.528 0.803 4 3.899-0.944 5.505 4.944-2.599 4.944 2.599-0.944-5.505 4-3.899z'%3E%3C/path%3E%3C/svg%3E");}.star-half{background-image:url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='${this.color}' viewBox='0 0 16 16'%3E%3Cpath d='M16 6.204l-5.528-0.803-2.472-5.009-2.472 5.009-5.528 0.803 4 3.899-0.944 5.505 4.944-2.599 4.944 2.599-0.944-5.505 4-3.899zM8 11.773l-0.015 0.008 0.015-8.918 1.746 3.537 3.904 0.567-2.825 2.753 0.667 3.888-3.492-1.836z'%3E%3C/path%3E%3C/svg%3E%0A");}.container:not(.readonly) .star{cursor:pointer;}</style>`;return a}}window.customElements.define("vp-rating",VPRating);