/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

(function(vme, document) {
	vme.updateStatus = function(action) {
		var request = new XMLHttpRequest();

		request.getResponseHeader('Content-type', 'application/json');

		request.onload = function() {
			var result = JSON.parse(this.responseText);

			if (!result.error) {
				if (result.products && result.products.length) {
					result.products.forEach(function(productId) {
						vme.addedAction(action, productId);
					})
				}
			}
		}

		request.onerror = function(e) {
			console.log(e);
		}
		
		request.open('GET', vme.base + 'index.php?option=com_vmessentials&task=' + action + '.getStatus&format=json&_' + Date.now() + '=1', true);

		// via Cache-Control header:
		request.setRequestHeader('Cache-Control', 'no-cache, no-store, max-age=0');

		// fallbacks for IE and older browsers:
		request.setRequestHeader('Expires', 'Tue, 01 Jan 1980 1:00:00 GMT');
		request.setRequestHeader('Pragma', 'no-cache');

		request.send();
	}

	document.addEventListener('DOMContentLoaded', function(event) {
		setTimeout(function() {
			vme.updateStatus('compare');
			vme.updateStatus('wishlist');
		}, 100);
	});
})(vme, document);
