<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

// Register class prefix
JLoader::registerPrefix('VMEssentials', JPATH_COMPONENT);

// Register primary controller class
JLoader::register('VMEssentialsController', JPATH_COMPONENT . '/controller.php');

if (!defined('VMESSENTIALS_ADMINISTRATOR'))
{
	require_once(JPATH_ADMINISTRATOR . '/components/com_vmessentials/include.php');
}

// Can not run Essentials for VirtueMart
if (!defined('VMESSENTIALS_ADMINISTRATOR'))
{
	return;
}

// Load VirtueMart Config and language
VmConfig::loadConfig();
VmConfig::loadJLang('com_virtuemart', true);

// Register helper class
JLoader::register('VMEssentialsHelper', VMESSENTIALS_ADMINISTRATOR . '/helpers/vmessentials.php');

// Register utility helper
JLoader::register('VMEssentialsHelperUtility', VMESSENTIALS_SITE . '/helpers/utility.php');

// Register route helper
JLoader::register('VMEssentialsHelperRoute', VMESSENTIALS_SITE . '/helpers/route.php');

// Force load compare controller
if (!class_exists('VMEssentialsControllerCompare'))
{
	require VMESSENTIALS_SITE . '/controllers/compare.php';
}

// Force load wishlist controller
if (!class_exists('VMEssentialsControllerWishlist'))
{
	require VMESSENTIALS_SITE . '/controllers/wishlist.php';
}

// Execute the task.
$controller = JControllerLegacy::getInstance('VMEssentials');

$controller->execute(JFactory::getApplication()->input->get('task'));
$controller->redirect();
