<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of Vmessentials.
 *
 * @since  1.6
 */
class VMEssentialsViewWishlist extends JViewLegacy
{
	protected $items;
	
	protected $permalink;

	protected $pagination;

	protected $state;

	protected $params;
	
	protected $currency;
	
	protected $count;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template name
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	public function display($tpl = null)
	{
		$app = JFactory::getApplication();

		$this->state      = $this->get('State');
		$this->items      = $this->get('Items');
		$this->pagination = $this->get('Pagination');
		$this->permalink  = $this->get('Permalink');
		$this->params     = $app->getParams('com_vmessentials');
		$this->currency   = CurrencyDisplay::getInstance();
		
		$all_product_ids  = $this->get('AllItemIds');
		$this->count      = !empty($all_product_ids) ? count($all_product_ids) : 0;
		
		if ($this->state->get('id'))
		{
			$userId = VMEssentialsHelperUtility::decode($this->state->get('id'), true);
			$userId = $userId ? (int) $userId : 0;
			
			if ($userId > 0)
			{
				$wishlistUser = JFactory::getUser($userId);
				
				if ($wishlistUser->get('id'))
				{
					$this->state->set('wishlist.user', $wishlistUser);
				}
			}
		}
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors));
		}
		
		JHtml::addIncludePath(VMESSENTIALS_SITE . '/helpers/html');

		$this->_prepareDocument();
		
		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	protected function _prepareDocument()
	{
		$app     = JFactory::getApplication();
		$pathway = $app->getPathway();
		$menus   = $app->getMenu();
		$title   = null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();

		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', JText::_('COM_VMESSENTIALS_DEFAULT_WISHLIST_PAGE_TITLE')));
			$title = $this->params->get('page_title', JText::_('COM_VMESSENTIALS_DEFAULT_WISHLIST_PAGE_TITLE'));
		}
		else
		{
			$this->params->def('page_heading', JText::_('COM_VMESSENTIALS_DEFAULT_WISHLIST_PAGE_TITLE'));
			$title = JText::_('COM_VMESSENTIALS_DEFAULT_WISHLIST_PAGE_TITLE');
			$pathway->addItem($title);
		}
		
		if ($this->params->get('show_page_heading') === null)
		{
			$this->params->set('show_page_heading', true);
		}
		
		if (empty($title))
		{
			$title = $app->get('sitename');
		}
		elseif ($app->get('sitename_pagetitles', 0) == 1)
		{
			$title = JText::sprintf('JPAGETITLE', $app->get('sitename'), $title);
		}
		elseif ($app->get('sitename_pagetitles', 0) == 2)
		{
			$title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));
		}

		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
		
		if ($this->permalink)
		{
			$this->document->addHeadLink(JRoute::_($this->permalink), 'canonical', 'rel', '');
		}
	}

	/**
	 * Check if state is set
	 *
	 * @param   mixed  $state  State
	 *
	 * @return bool
	 */
	public function getState($state)
	{
		return isset($this->state->{$state}) ? $this->state->{$state} : false;
	}
}
