<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

vmJsApi::jPrice();
vmJsApi::cssSite();

$pageUrl      = VMEssentialsHelperRoute::getRoute('wishlist');
$pageUrl      = JRoute::_($pageUrl, false);
$return       = VMEssentialsHelperUtility::encode($pageUrl);
$wishlistUser = $this->state->get('wishlist.user', null);
?>
<div class="vmessentials-wrapper vme-wishlist">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1>
				<?php echo $this->escape($this->params->get('page_heading')); ?>
			</h1>
			<?php if ($wishlistUser) : ?>
				<h5>
					<?php echo JText::sprintf('COM_VMESSENTIALS_WISHLIST_HEADING', $wishlistUser->get('name')); ?>
				</h5>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<?php if (empty($this->items)) : ?>
		<div class="vme-empty-list">
			<?php echo JText::_('COM_VMESSENTIALS_EMPTY_WISHLIST'); ?>
		</div>
	<?php else : ?>
		<?php if (!$this->state->get('id')) : ?>
			<div class="vme-share-container vme-popover-wrapper">
				<button type="button" class="btn-vme" data-vmepopover="true"><?php echo JText::_('COM_VMESSENTIALS_SHARE'); ?><span class="vme-dropdown-caret"></span></button>
				<div class="vme-popover">
					<div class="vme-share-inner">
						<?php if (!$this->permalink) : ?>
							<p><?php echo JText::_('COM_VMESSENTIALS_MSG_WISHLIST_NEED_LOGIN_SHARE'); ?></p>
							<a href="<?php echo JRoute::_('index.php?option=com_users&view=login&return=' . $return); ?>" class="btn-vme"><?php echo JText::_('JLOGIN'); ?></a>
						<?php else : ?>
							<div class="vme-share-title"><?php echo JText::_('COM_VMESSENTIALS_PERMALINK'); ?></div>
							<div class="vme-input-section">
								<div class="vme-input-group">
									<input type="text" class="vme-form-control" value="<?php echo JRoute::_($this->permalink, true, 0, true); ?>" aria-label="<?php echo JRoute::_($this->permalink, true, 0, true); ?>" data-vmecopyfield="true" readonly />
									<div class="vme-input-group-btn">
										<button type="button" class="btn-vme" data-vmecopy="true" data-vmedonetext="<?php echo $this->escape(JText::_('COM_VMESSENTIALS_COPIED')); ?>">
											<?php echo JText::_('COM_VMESSENTIALS_COPY'); ?>
										</button>
									</div>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
			<br />
		<?php endif; ?>
	
		<form action="<?php echo htmlspecialchars(JUri::getInstance()->toString()); ?>" method="post" class="form-inline clearfix">
			<?php if ($this->params->get('show_pagination_limit', 1)) : ?>
				<div class="pull-right">
					<label for="limit"><?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?></label>
					<?php echo $this->pagination->getLimitBox(); ?>
				</div>
			<?php endif; ?>
			<input type="hidden" name="limitstart" value="" />
			<input type="hidden" name="task" value="" />
		</form>
		
		<?php foreach ($this->items as $product) : ?>
			<?php
			$btn_quickview = JHtml::_('vmessentials.quickview', $product, false);
			$btn_compare   = JHtml::_('vmessentials.addtocompare', $product, false);
			?>
			<div class="vme-list-item product-item product-container">
				<div class="vme-row">
					<div class="vme-column vme-list-left">
						<?php if (!empty($product->images[0])) : ?>
							<div class="vme-list-image">
								<a href="<?php echo JRoute::_($product->link); ?>"><?php echo $product->images[0]->displayMediaThumb('class="vme-image"', false); ?></a>
							</div>
						<?php endif; ?>
						<?php if (!$this->state->get('id')) : ?>
							<div class="vme-list-remove">
								<form action="<?php echo JRoute::_('index.php?option=com_vmessentials&view=wishlist') ?>" method="post" class="vmessentials-form">
									<button type="submit" class="btn-vme-text"><?php echo JText::_('COM_VMESSENTIALS_REMOVE_FROM_WISHLIST') ?></button>
									<input type="hidden" name="option" value="com_vmessentials" />
									<input type="hidden" name="task" value="wishlist.remove" />
									<input type="hidden" name="virtuemart_product_id" value="<?php echo (int) $product->virtuemart_product_id; ?>" />
									<input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>" />
									<?php echo JHtml::_('form.token'); ?>
									<?php echo JHtml::_('vmessentials.returnUri'); ?>
								</form>
							</div>
						<?php endif; ?>
					</div>
					<div class="vme-column vme-list-right">
						<div class="vme-list-section">
							<h3><?php echo JHtml::link(JRoute::_($product->link), $product->product_name); ?></h3>
						</div>
						<div class="vme-list-section clearfix">
							<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $this->currency)); ?>
						</div>
						<?php if (!empty($product->product_s_desc)) : ?>
							<div class="vme-list-section">
								<?php echo $product->product_s_desc; ?>
							</div>
						<?php endif; ?>
						<?php if ($this->params->get('addtocart_in_wishlist', 1)) : ?>
						<div class="vme-list-section">
							<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $product, 'isList' => false)); ?>
						</div>
						<?php endif; ?>
						<?php if (!empty($btn_quickview) || !empty($btn_compare)) : ?>
							<div class="vme-list-section">
								<ul class="vme-list-inline">
									<?php if (!empty($btn_quickview)) : ?>
										<li><?php echo $btn_quickview; ?></li>
									<?php endif; ?>
									<?php if (!empty($btn_compare)) : ?>
										<li><?php echo $btn_compare; ?></li>
									<?php endif; ?>
								</ul>
							</div>
						<?php endif; ?>
					</div>
				</div>
			</div>
		<?php endforeach; ?>
		<?php if ($this->pagination->pagesTotal > 1) : ?>
			<div class="pagination">
				<p class="counter pull-right">
					<?php echo $this->pagination->getPagesCounter(); ?>
				</p>
				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php endif; ?>
	<?php endif; ?>
</div>
<?php echo vmJsApi::writeJS(); ?>