<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

JHtml::_('jquery.framework');
JHtml::_('stylesheet', 'com_vmessentials/jquery.owl.carousel.min.css', array('relative' => true));
JHtml::_('script', 'com_vmessentials/jquery.owl.carousel.min.js', array('relative' => true));
JHtml::_('script', 'com_vmessentials/jquery.cloudzoom.modified.min.js', array('relative' => true));

$this->document->addScriptDeclaration("
  jQuery(document).ready(function($) {
    $('.product-thumb-carousel').owlCarousel({
      itemsCustom: [ [0, 1], [219, 2], [299, 3], [459, 4], [640, 5], [747, 3], [1259, 4] ],
      responsiveRefreshRate: 50,
      autoPlay: 5000,
      theme: 'owl-thumbnail-carousel',
      navigation: true,
      pagination: false,
      slideSpeed: 200,
      paginationSpeed: 800,
      rewindSpeed: 600,
      stopOnHover: true,
      rewindNav: true,
      navigationText: false
    });
  });
");
?>
<?php if (!empty($this->product->images)) : ?>
	<?php 
	$image = new VMEssentialsImage($this->product->images[0]); 
	$fullImage = $image->getFull($this->product->product_name);
	?>
	<div class="product-image-gallery-cont">
		<div class="product-image-gallery-main-cont">
			<a href="<?php echo $fullImage['url'] ?>" class="vpf-zoom" id="product-image-gallery" rel="adjustX: 10, adjustY:0">
				<img src="<?php echo $fullImage['url'] ?>" alt="<?php echo $fullImage['alt'] ?>" class="responsive-image"/>
			</a>
		</div>
		<?php if (count($this->product->images) > 1) : ?>
			<div class="product-thumb-carousel owl-carousel owl-thumbnail-carousel">
				<?php foreach ($this->product->images as $key => $image) : ?>
					<?php 
					$image = new VMEssentialsImage($image); 
					$fullImage = $image->getFull($this->product->product_name);
					$thumbImage = $image->getThumb($this->product->product_name);
					$class = 'vpf-zoom-gallery';
					?>
					<div class="image-thumb<?php echo ($key == 0) ? ' active' : ''; ?>">
						<a href="<?php echo $fullImage['url'] ?>" class="<?php echo $class ?>" data-key="<?php echo $key ?>" data-sync="#product-light-box-images" rel="useZoom: 'product-image-gallery', smallImage: '<?php echo htmlspecialchars($fullImage['url']); ?>'">
							<img src="<?php echo $thumbImage['url'] ?>" alt="<?php echo $thumbImage['alt'] ?>" />
						</a>
					</div>
				<?php endforeach; ?>
			</div>
		<?php endif; ?>
	</div>
<?php endif; ?>