<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

vmJsApi::jPrice();
vmJsApi::cssSite();

$product_url  = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id .
                         '&virtuemart_category_id=' . $this->product->virtuemart_category_id);
$btn_wishlist = $this->params->get('quickview_show_addtowishlist', 1) ? JHtml::_('vmessentials.addtowishlist', $this->product, false) : null;
$btn_compare  = $this->params->get('quickview_show_addtocompare', 1) ? JHtml::_('vmessentials.addtocompare', $this->product, false) : null;
?>
<div class="vmessentials-wrapper productdetails-view vm-productdetails vme-quickview" data-vm="product-container">
	<div class="vme-container">
		<div class="vme-row">
			<div class="vme-column vme-quickview-left">
				<?php echo $this->loadTemplate('imagegallery'); ?>
			</div>
			<div class="vme-column vme-quickview-right">
				<div class="product-title-cont">
					<h1 class="product-title">
						<a href="<?php echo $product_url ?>" class="hover-invert" target="_top"><?php echo $this->product->product_name ?></a>
					</h1>
				</div>
				<?php if (!empty($this->product->event->afterDisplayTitle)) : ?>
					<div class="eventAfterDisplayTitle">
						<?php echo $this->product->event->afterDisplayTitle ?>
					</div>
				<?php endif; ?>
				<?php if ($this->showRating) : ?>
					<div class="product-rating-cont clearfix">
						<?php echo JHtml::_('vmessentials.rating', $this->product); ?>
					</div>
				<?php endif; ?>
				<div class="product-price-stock-sku-cont">
					<div class="quick-price-container clearfix">
						<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $this->product, 'currency' => $this->currency)); ?>
					</div>
				</div>
				<?php if (!empty($this->product->product_s_desc)) : ?>
					<div class="product-short-desc-cont">
						<?php echo $this->product->product_s_desc ?>
					</div>
				<?php endif; ?>
				<?php if ($this->params->get('quickview_show_addtocart', 1)) : ?>
					<div class="product-addtocart-cont">
						<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $this->product)); ?>
					</div>
				<?php endif; ?>
				<?php if (!empty($btn_wishlist) || !empty($btn_compare)) : ?>
					<div class="product-action-buttons-cont">
						<ul class="vme-list-inline">
							<?php if (!empty($btn_wishlist)) : ?>
								<li><?php echo $btn_wishlist; ?></li>
							<?php endif; ?>
							<?php if (!empty($btn_compare)) : ?>
								<li><?php echo $btn_compare; ?></li>
							<?php endif; ?>
						</ul>
					</div>
				<?php endif; ?>
			</div>
		</div>
		
		<?php if (VmConfig::get('product_navigation', 1)) : ?>
			<div class="product-neighbours">
				<?php if (!empty($this->product->neighbours['previous'][0])) : ?>
					<?php
					$prev_link = JRoute::_('index.php?option=com_vmessentials&view=quickview&tmpl=component&virtuemart_product_id=' . $this->product->neighbours['previous'][0]['virtuemart_product_id']);
					$prev_product_name = $this->product->neighbours ['previous'][0]['product_name'];
					?>
					<a href="<?php echo $prev_link ?>" class="neighbour-link neighbour-previous pull-left" title="<?php echo $prev_product_name ?>" rel="nofollow">
						<i class="fa fa-chevron-left"></i><span class="sr-only"><?php echo $prev_product_name ?></span>
					</a>
				<?php endif; ?>
				<?php if (!empty($this->product->neighbours['next'][0])) : ?>
					<?php
					$next_link = JRoute::_('index.php?option=com_vmessentials&view=quickview&tmpl=component&virtuemart_product_id=' . $this->product->neighbours['next'][0]['virtuemart_product_id']);
					$next_product_name = $this->product->neighbours ['next'][0]['product_name'];
					?>
					<a href="<?php echo $next_link ?>" class="neighbour-link neighbour-next" title="<?php echo $next_product_name ?>" rel="nofollow">
						<i class="fa fa-chevron-right"></i><span class="sr-only"><?php echo $next_product_name ?></span>
					</a>
				<?php endif; ?>
			</div>
		<?php endif; ?>
	
	</div>
</div>
<?php echo vmJsApi::writeJS(); ?>
<script type="text/javascript">
  Virtuemart.container = jQuery('.productdetails-view');
  Virtuemart.containerSelector = '.productdetails-view';
</script>

