<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2016 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of Vmessentials.
 *
 * @since  1.6
 */
class VMEssentialsViewCompare extends JViewLegacy
{
	protected $variables;
	
	protected $items;
	
	protected $permalink;
	
	protected $fields;

	protected $pagination;

	protected $state;
	
	protected $showRating;

	protected $params;
	
	protected $currency;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template name
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	public function display($tpl = null)
	{
		$app              = JFactory::getApplication();
		$ratingModel      = VmModel::getModel('ratings');

		$this->state      = $this->get('State');
		$this->items      = $this->get('Items');
		$this->permalink  = $this->get('Permalink');
		$this->fields     = $this->get('CompareFields');
		$this->params     = $app->getParams('com_vmessentials');
		$this->showRating = $ratingModel->showRating();
		
		$this->variables  = array(
			'product_name', 'image',
			'rating', 'product_sku',
			'price', 'product_category',
			'mf_name', 'product_s_desc',
			'product_desc', 'product_length',
			'product_width', 'product_height',
			'product_weight', 'product_packaging',
			'product_box', 'product_availability',
			'product_stock', 'custom_fields',
			'add_to_cart'
		);

		$this->variables = (array) $this->params->get('compare_display_order', $this->variables);
		
		JLoader::register('CurrencyDisplay', JPATH_SITE . '/components/com_virtuemart/helpers/currencydisplay.php');
		
		$this->currency = CurrencyDisplay::getInstance();
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors));
		}

		JHtml::addIncludePath(VMESSENTIALS_SITE . '/helpers/html');

		$this->_prepareDocument();

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	protected function _prepareDocument()
	{
		$app     = JFactory::getApplication();
		$pathway = $app->getPathway();
		$menus   = $app->getMenu();
		$title   = null;

		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();

		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', JText::_('COM_VMESSENTIALS_DEFAULT_COMPARE_PAGE_TITLE')));
			$title = $this->params->get('page_title', $this->params->get('page_title', JText::_('COM_VMESSENTIALS_DEFAULT_COMPARE_PAGE_TITLE')));
		}
		else
		{
			$this->params->def('page_heading', JText::_('COM_VMESSENTIALS_DEFAULT_COMPARE_PAGE_TITLE'));
			$title = JText::_('COM_VMESSENTIALS_DEFAULT_COMPARE_PAGE_TITLE');
			$pathway->addItem($title);
		}
		
		if ($this->params->get('show_page_heading') === null)
		{
			$this->params->set('show_page_heading', true);
		}
		
		if (empty($title))
		{
			$title = $app->get('sitename');
		}
		elseif ($app->get('sitename_pagetitles', 0) == 1)
		{
			$title = JText::sprintf('JPAGETITLE', $app->get('sitename'), $title);
		}
		elseif ($app->get('sitename_pagetitles', 0) == 2)
		{
			$title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));
		}

		$this->document->setTitle($title);

		if ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}

		if ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}

		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
		
		if ($this->permalink)
		{
			$this->document->addHeadLink(JRoute::_($this->permalink), 'canonical', 'rel', '');
		}
	}
	
	protected function getTitle($variable)
	{
		$variable = (string) $variable;
		
		$variables  = array(
			'product_name'         => vmText::_('COM_VIRTUEMART_PRODUCT_NAME'),
			'image'                => '',
			'rating'               => vmText::_('COM_VIRTUEMART_RATING'),
			'product_sku'          => vmText::_('COM_VIRTUEMART_PRODUCT_SKU'),
			'price'                => vmText::_('COM_VIRTUEMART_PRODUCT_PRICE'),
			'product_category'     => vmText::_('COM_VIRTUEMART_CATEGORY'),
			'mf_name'              => vmText::_('COM_VIRTUEMART_MF_NAME'),
			'product_s_desc'       => vmText::_('COM_VIRTUEMART_PRODUCT_S_DESC'),
			'product_desc'         => vmText::_('COM_VIRTUEMART_PRODUCT_DESC'),
			'product_length'       => vmText::_('COM_VIRTUEMART_PRODUCT_LENGTH'),
			'product_width'        => vmText::_('COM_VIRTUEMART_PRODUCT_WIDTH'),
			'product_height'       => vmText::_('COM_VIRTUEMART_PRODUCT_HEIGHT'),
			'product_weight'       => vmText::_('COM_VIRTUEMART_PRODUCT_WEIGHT'),
			'product_packaging'    => vmText::_('COM_VIRTUEMART_PRODUCT_PACKAGING'),
			'product_box'          => vmText::_('COM_VIRTUEMART_PRODUCT_UNITS_IN_BOX'),
			'product_availability' => vmText::_('COM_VIRTUEMART_PRODUCT_AVAILABILITY'),
			'product_stock'        => vmText::_('COM_VIRTUEMART_STOCK_LEVEL_DISPLAY_TITLE_TIP'),
			'custom_fields'        => vmText::_('COM_VIRTUEMART_CUSTOM'),
			'add_to_cart'          => vmText::_('COM_VIRTUEMART_CART_ADD_TO')
		);
		
		if (isset($variables[$variable]))
		{
			return $variables[$variable];
		}
		
		$lang = JFactory::getLanguage();
		
		if ($lang->hasKey($variable))
		{
			return JText::_($variable);
		}
		
		$vmKey = 'COM_VIRTUEMART_' . strtoupper($variable);
		
		if ($lang->hasKey($vmKey))
		{
			return JText::_($vmKey);
		}
		
		$vmeKey = 'COM_VMESSENTIALS_' . strtoupper($variable);
		
		if ($lang->hasKey($vmeKey))
		{
			return JText::_($vmeKey);
		}
		
		return ucwords(str_replace('_', ' ', $variable));
	}
	
	protected function show($var, $default = false)
	{
		$show = $default;
		
		if (in_array($var, $this->variables))
		{
			$show = $var == 'product_name' ||
			        ($var == 'product_category' && $this->params->get('compare_show_category', 1)) ||
			        ($var == 'mf_name' && $this->params->get('compare_show_manufacturer', 1)) ||
			        ($var == 'rating' && $this->params->get('compare_show_rating', 1)) ||
			        ($var == 'image' && $this->params->get('compare_show_image', 1)) ||
			        ($var == 'product_sku' && $this->params->get('compare_show_sku', 1)) ||
			        ($var == 'price' && $this->params->get('compare_show_price', 1)) ||
			        ($var == 'product_s_desc' && $this->params->get('compare_show_short_description', 1)) ||
			        ($var == 'product_desc' && $this->params->get('compare_show_description', 1)) ||
			        ($var == 'product_length' && $this->params->get('compare_show_length', 1)) ||
			        ($var == 'product_width' && $this->params->get('compare_show_width', 1)) ||
			        ($var == 'product_height' && $this->params->get('compare_show_height', 1)) ||
			        ($var == 'product_weight' && $this->params->get('compare_show_weight', 1)) ||
			        ($var == 'product_packaging' && $this->params->get('compare_show_packaging', 1)) ||
			        ($var == 'product_box' && $this->params->get('compare_show_unitinbox', 1)) ||
			        ($var == 'add_to_cart' && $this->params->get('compare_show_add_to_cart', 1)) ||
			        ($var == 'custom_fields' && $this->params->get('compare_show_customfields', 1)) ||
			        ($var == 'product_availability' && $this->params->get('compare_show_availability', 1)) ||
			        ($var == 'product_stock' && $this->params->get('compare_show_stock', 1));
		}
		
		return $show;
	}

	
	/**
	 * Check if state is set
	 *
	 * @param   mixed  $state  State
	 *
	 * @return bool
	 */
	public function getState($state)
	{
		return isset($this->state->{$state}) ? $this->state->{$state} : false;
	}
}
