<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

vmJsApi::jPrice();
vmJsApi::cssSite();

if (!empty($this->items))
{
	$count          = count($this->items);
	$availableWidth = 80;

	$css  = '.vme-compare-title{width:20%;}';
	$css .= '.vme-compare-data{width:' . ceil($availableWidth / $count) . '%;max-width:40%;}';
	
	JFactory::getDocument()->addStyleDeclaration($css);
}
?>
<div class="vmessentials-wrapper">
	<?php if ($this->params->get('show_page_heading')) : ?>
		<div class="page-header">
			<h1><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
		</div>
	<?php endif; ?>
	<?php if (empty($this->items)) : ?>
		<div class="vme-empty-list">
			<?php echo JText::_('COM_VMESSENTIALS_EMPTY_COMPARE'); ?>
		</div>
	<?php else : ?>
		<div class="vme-share-container vme-popover-wrapper">
			<button type="button" class="btn-vme" data-vmepopover="true"><?php echo JText::_('COM_VMESSENTIALS_SHARE'); ?><span class="vme-dropdown-caret"></span></button>
			<div class="vme-popover">
				<div class="vme-share-inner">
					<div class="vme-share-title"><?php echo JText::_('COM_VMESSENTIALS_PERMALINK'); ?></div>
					<div class="vme-input-section">
						<div class="vme-input-group">
							<input type="text" class="vme-form-control" value="<?php echo JRoute::_($this->permalink, true, 0, true); ?>" aria-label="<?php echo JRoute::_($this->permalink, true, 0, true); ?>" data-vmecopyfield="true" readonly />
							<div class="vme-input-group-btn">
								<button type="button" class="btn-vme" data-vmecopy="true" data-vmedonetext="<?php echo $this->escape(JText::_('COM_VMESSENTIALS_COPIED')); ?>">
									<?php echo JText::_('COM_VMESSENTIALS_COPY'); ?>
								</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="vme-table-container">
			<table class="vme-table">
				<?php foreach ($this->variables as $var) : ?>
					<?php if ($var == 'custom_fields' && $this->show($var) && !empty($this->fields)) : ?>
						<?php foreach ($this->fields as $id => $name) : ?>
							<tr class="<?php echo 'vmevar_' . $var; ?> customfield-<?php echo $id ?>">
								<th class="vme-compare-title"><?php echo $name ?></th>
								<?php foreach ($this->items as $product) : ?>
									<td>
										<?php if (!empty($product->customfieldsGrouped[$id]))
										{
											foreach ($product->customfieldsGrouped[$id] as $i => $field)
											{
												echo $field->display; 
												echo '<div class="vme-separator"></div>';
											}
										} ?>
									</td>
								<?php endforeach; ?>
							</tr>
						<?php endforeach; ?>
					<?php elseif ($this->show($var)) : ?>
						<tr class="<?php echo 'vmevar_' . $var; ?>">
							<th class="vme-compare-title"><?php echo $this->getTitle($var) ?></th>
							<?php foreach ($this->items as $product) : ?>
								<td class="vme-compare-data">
									<?php if ($var == 'product_name') : ?>
										<h3><?php echo JHtml::link(JRoute::_($product->link), $product->product_name); ?></h3>
										<?php if (!$this->state->get('has_id')) : ?>
											<form action="<?php echo JRoute::_('index.php?option=com_vmessentials&view=compare') ?>" method="post" class="vmessentials-form">
												<button type="submit" class="vme-compare-remove btn-vme-round" title="<?php echo JText::_('COM_VMESSENTIALS_REMOVE_ITEM') ?>">
													<i class="fa fa-times" aria-hidden="true"></i>
												</button>
												<input type="hidden" name="option" value="com_vmessentials" />
												<input type="hidden" name="task" value="compare.remove" />
												<input type="hidden" name="virtuemart_product_id" value="<?php echo (int) $product->virtuemart_product_id; ?>" />
												<input type="hidden" name="product_name" value="<?php echo htmlspecialchars($product->product_name, ENT_COMPAT, 'UTF-8'); ?>" />
												<?php echo JHtml::_('form.token'); ?>
												<?php echo JHtml::_('vmessentials.returnUri'); ?>
											</form>
										<?php endif; ?>
									<?php elseif ($var == 'product_category' && !empty($product->virtuemart_category_id)) : ?>
										<a href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $product->virtuemart_category_id) ?>" target="_blank">
											<?php echo $product->category_name; ?></a>
									<?php elseif ($var == 'mf_name' && !empty($product->virtuemart_manufacturer_id[0])) : ?>
										<a href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id=0&virtuemart_manufacturer_id=' . $product->virtuemart_manufacturer_id[0]) ?>" target="_blank">
											<?php echo $product->mf_name; ?></a>
									<?php elseif ($var == 'rating') : ?>
										<?php echo JHtml::_('vmessentials.rating', $product); ?>
									<?php elseif ($var == 'image' && !empty($product->images[0])) : ?>
										<a href="<?php echo JRoute::_($product->link); ?>"><?php echo $product->images[0]->displayMediaThumb('class="vme-image"', false); ?></a>
										<div class="vme-compare-buttons">
											<ul class="vme-list-inline">
												<li><?php echo JHtml::_('vmessentials.addtowishlist', $product, false); ?></li>
												<li><?php echo JHtml::_('vmessentials.quickview', $product, false); ?></li>
											</ul>
										</div>
									<?php elseif ($var == 'product_sku') : ?>
										<?php echo $product->product_sku; ?>
									<?php elseif ($var == 'price') : ?>
										<?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $this->currency)); ?>
									<?php elseif ($var == 'product_s_desc') : ?>
										<?php echo $product->product_s_desc; ?>
									<?php elseif ($var == 'product_desc') : ?>
										<?php echo $product->product_desc; ?>
									<?php elseif ($var == 'product_length' && !empty($product->product_length)) : ?>
										<?php echo (float) $product->product_length . ' ' . $product->product_lwh_uom; ?>
									<?php elseif ($var == 'product_width' && !empty($product->product_width)) : ?>
										<?php echo (float) $product->product_width . ' ' . $product->product_lwh_uom; ?>
									<?php elseif ($var == 'product_height' && !empty($product->product_height)) : ?>
										<?php echo (float) $product->product_height . ' ' . $product->product_lwh_uom; ?>
									<?php elseif ($var == 'product_weight' && !empty($product->product_weight)) : ?>
										<?php echo (float) $product->product_weight . ' ' . $product->product_weight_uom; ?>
									<?php elseif ($var == 'product_packaging' && !empty($product->product_packaging)) : ?>
										<?php echo (float) $product->product_packaging . ' ' . $product->product_unit; ?>
									<?php elseif ($var == 'product_box' && !empty($product->product_box)) : ?>
										<?php echo $product->product_box; ?>
									<?php elseif ($var == 'product_availability') : ?>
										<?php echo shopFunctionsF::renderVmSubLayout('stockhandle', array('product' => $product)) ?>
									<?php elseif ($var == 'product_stock') : ?>
										<?php echo $product->stock->stock_tip; ?>
									<?php elseif ($var == 'add_to_cart') : ?>
										<div class="product-container">
											<?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $product, 'isList' => false)); ?>
										</div>
									<?php endif; ?>
								</td>
							<?php endforeach; ?>
						</tr>
					<?php endif; ?>
				<?php endforeach; ?>
			</table>
		</div>
	<?php endif; ?>
</div>
<?php echo vmJsApi::writeJS(); ?>
