<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

$product   = isset($displayData['product']) ? $displayData['product'] : null;
$maxrating = VmConfig::get('vm_maximum_rating_scale', 5);
$rating    = !empty($product->rating) ? $product->rating : 0;
?>
<div class="product-rating">
	<vp-rating max="<?php echo $maxrating; ?>" rating="<?php echo round($rating); ?>" half="true" color="#FF9529" size="16" readonly="true" unrated-msg="<?php echo htmlspecialchars(vmText::_('COM_VIRTUEMART_UNRATED'), ENT_QUOTES, 'UTF-8'); ?>" hint="<?php echo htmlspecialchars(vmText::_('COM_VIRTUEMART_REVIEW_STARS'), ENT_QUOTES, 'UTF-8'); ?>"></vp-rating>
</div>
