<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

// Initialize some variables
$app       = JFactory::getApplication();
$product   = isset($displayData['product']) ? $displayData['product'] : null;
$params    = isset($displayData['params']) ? $displayData['params'] : $app->getParams('com_vmessentials');
$iconOnly  = isset($displayData['iconOnly']) ? $displayData['iconOnly'] : false;
$url       = isset($displayData['url']) ? $displayData['url'] : null;
$iconClass = isset($displayData['iconClass']) ? $displayData['iconClass'] : '';
$btnClass  = isset($displayData['btnClass']) ? $displayData['btnClass'] : '';
?>
<a href="<?php echo $url ?>" class="has-vme-tooltip <?php echo $btnClass ?>" target="_blank" rel="nofollow" data-iframe-modal>
	<?php if (!empty($iconClass)) : ?>
		<i class="<?php echo $iconClass ?>" aria-hidden="true"></i>
	<?php endif; ?>
	<?php if (!$iconOnly) : ?>
		<span><?php echo JText::_('COM_VMESSENTIALS_QUICKVIEW'); ?></span>
	<?php endif; ?>
	<span class="vme-tooltip"><?php echo JText::_('COM_VMESSENTIALS_QUICKVIEW'); ?></span>
</a>
