<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

/**
 * VMEssentials Utility Helper
 *
 * @since  1.0
 */
class VMEssentialsHelperUtility
{
	public static $encoding = 'base';

	public static $encoding_suffix = '64';

	public static function encode($string)
	{
		$function = strtolower(self::$encoding . self::$encoding_suffix . '_encode');
		
		if (function_exists($function))
		{
			return call_user_func($function, $string);
		}
		
		return false;
	}
	
	public static function decode($string, $strict = false)
	{
		$function = strtolower(self::$encoding . self::$encoding_suffix . '_decode');
		
		if (function_exists($function))
		{
			return call_user_func($function, $string, $strict);
		}
		
		return false;
	}
	
	public static function getEncodeFilter()
	{
		return strtoupper(self::$encoding . self::$encoding_suffix);
	}
	
	public static function isValidEncodedString($string)
	{
		if (self::encode(self::decode($string, true)) === $string)
		{
			return true;
		}
		
		return false;
	}
	
	public static function jsonReturn($output = array()) 
	{
		$app     = JFactory::getApplication();
		$obLevel = ob_get_level();
		
		if ($obLevel)
		{
			while ($obLevel > 0)
			{
				ob_end_clean();
				$obLevel --;
			}
		}
		elseif (ob_get_contents())
		{
			ob_clean();
		}
		
		header('Content-type: application/json');
		header('Cache-Control: public,max-age=1,must-revalidate');
		header('Expires: ' . gmdate('D, d M Y H:i:s', ($_SERVER['REQUEST_TIME'] + 1)) . ' GMT');
		header('Last-modified: ' . gmdate('D, d M Y H:i:s', $_SERVER['REQUEST_TIME']) . ' GMT');

		if (function_exists('header_remove')) 
		{
			header_remove('Pragma');
		}

		echo json_encode($output);
		
		flush();
		$app->close();
	}
}
