<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

/**
 * Essentials for VirtueMart Route Helper
 *
 * @since  1.0
 */
class VMEssentialsHelperRoute
{
	public static $routes = array();
	
	/**
	 * Method to get the menu items for the component.
	 *
	 * @return  array   An array of menu items.
	 *
	 * @since   1.0
	 */
	public static function &getItems()
	{
		static $items;

		// Get the menu items for this component.
		if (!isset($items))
		{
			$app   = JFactory::getApplication();
			$menu  = $app->getMenu();
			$com   = JComponentHelper::getComponent('com_vmessentials');
			$items = $menu->getItems('component_id', $com->id);

			// If no items found, set to empty array.
			if (!$items)
			{
				$items = array();
			}
		}

		return $items;
	}
	
	public static function getRoute($view)
	{
		$view = strtolower(trim($view));
		
		if (!in_array($view, array('wishlist', 'compare')))
		{
			$view = 'wishlist';
		}
		
		if (!isset(self::$routes[$view]))
		{
			// Get the items.
			$items  = self::getItems();
			$itemid = null;

			// Search for a suitable menu id.
			foreach ($items as $item)
			{
				if (isset($item->query['view']) && $item->query['view'] === $view)
				{
					$itemid = $item->id;
					break;
				}
			}
			
			$url = 'index.php?option=com_vmessentials&view=' . $view;
			
			if ($itemid)
			{
				$url .= '&Itemid=' . $itemid;
			}
			
			self::$routes[$view] = $url;
		}
		
		return self::$routes[$view];
	}
}
