<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

JLoader::register('VMEssentialsHelperUtility', VMESSENTIALS_SITE . '/helpers/utility.php');

/**
 * Items list controller class.
 *
 * @since  1.6
 */
class VMEssentialsControllerWishlist extends VMEssentialsController
{
	public function add()
	{
		$app          = JFactory::getApplication();
		$params       = $app->getParams('com_vmessentials');
		$user         = JFactory::getUser();
		$doc          = JFactory::getDocument();
		$input        = $app->input;
		$model        = $this->getModel();
		$product_id   = $input->getInt('virtuemart_product_id', 0);
		$product_name = $input->getString('product_name', '');
		$return       = $input->get('return', null, VMEssentialsHelperUtility::getEncodeFilter());
		$format       = strtoupper($doc->getType());
		
		if (!$params->get('enable_wishlist', 1))
		{
			if ($format == 'JSON')
			{
				$this->jsonReturn(array('error' => 1, 'msg' => JText::_('COM_VMESSENTIALS_MSG_WISHLIST_DISABLED')));
			}
			else
			{
				$this->setMessage(JText::_('COM_VMESSENTIALS_MSG_WISHLIST_DISABLED'), 'warning');
			}
		}
		elseif ($user->get('guest') && !$params->get('guest_wishlist', 1))
		{
			if ($format == 'JSON')
			{
				$this->jsonReturn(array('error' => 1, 'msg' => JText::_('COM_VMESSENTIALS_MSG_WISHLIST_NEED_LOGIN_ADD')));
			}
			else
			{
				$this->setMessage(JText::_('COM_VMESSENTIALS_MSG_WISHLIST_NEED_LOGIN_ADD'), 'warning');
			}
		}
		elseif (!$model->add($product_id))
		{
			if ($format == 'JSON')
			{
				$this->jsonReturn(array('error' => 1, 'msg' => $model->getError()));
			}
			else
			{
				$this->setMessage($model->getError(), 'warning');
			}
		}
		else
		{
			if (empty($product_name))
			{
				if ($format == 'JSON')
				{
					$this->jsonReturn(array('error' => 0, 'msg' => JText::_('COM_VMESSENTIALS_WISHLIST_PRODUCT_ADDED')));
				}
				
				$this->setMessage(JText::_('COM_VMESSENTIALS_WISHLIST_PRODUCT_ADDED'), 'success');
			}
			else
			{
				if ($format == 'JSON')
				{
					$this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('COM_VMESSENTIALS_WISHLIST_PRODUCT_NAME_ADDED', $product_name)));
				}
				
				$this->setMessage(JText::sprintf('COM_VMESSENTIALS_WISHLIST_PRODUCT_NAME_ADDED', $product_name), 'success');
			}
		}
		
		if (!empty($return))
		{
			$return = VMEssentialsHelperUtility::decode($return);
			
			if (JUri::isInternal($return))
			{
				$this->setRedirect(JRoute::_($return, false));
			}
		}
	}
	
	public function remove()
	{
		$app          = JFactory::getApplication();
		$params       = $app->getParams('com_vmessentials');
		$user         = JFactory::getUser();
		$doc          = JFactory::getDocument();
		$input        = $app->input;
		$model        = $this->getModel();
		$product_id   = $input->getInt('virtuemart_product_id', 0);
		$product_name = $input->getString('product_name', '');
		$return       = $input->get('return', null, VMEssentialsHelperUtility::getEncodeFilter());
		$format       = strtoupper($doc->getType());
		
		if (!$params->get('enable_wishlist', 1))
		{
			if ($format == 'JSON')
			{
				$this->jsonReturn(array('error' => 1, 'msg' => JText::_('COM_VMESSENTIALS_MSG_WISHLIST_DISABLED')));
			}
			else
			{
				$this->setMessage(JText::_('COM_VMESSENTIALS_MSG_WISHLIST_DISABLED'), 'warning');
			}
		}
		elseif ($user->get('guest') && !$params->get('guest_wishlist', 1))
		{
			if ($format == 'JSON')
			{
				$this->jsonReturn(array('error' => 1, 'msg' => JText::_('COM_VMESSENTIALS_MSG_WISHLIST_NEED_LOGIN_REMOVE')));
			}
			else
			{
				$this->setMessage(JText::_('COM_VMESSENTIALS_MSG_WISHLIST_NEED_LOGIN_REMOVE'), 'warning');
			}
		}
		elseif (!$model->remove($product_id))
		{
			if ($format == 'JSON')
			{
				$this->jsonReturn(array('error' => 1, 'msg' => $model->getError()));
			}
			else
			{
				$this->setMessage($model->getError(), 'warning');
			}
		}
		else
		{
			if (empty($product_name))
			{
				if ($format == 'JSON')
				{
					$this->jsonReturn(array('error' => 0, 'msg' => JText::_('COM_VMESSENTIALS_WISHLIST_PRODUCT_REMOVED')));
				}
				
				$this->setMessage(JText::_('COM_VMESSENTIALS_WISHLIST_PRODUCT_REMOVED'), 'success');
			}
			else
			{
				if ($format == 'JSON')
				{
					$this->jsonReturn(array('error' => 0, 'msg' => JText::sprintf('COM_VMESSENTIALS_WISHLIST_PRODUCT_NAME_REMOVED', $product_name)));
				}
				
				$this->setMessage(JText::sprintf('COM_VMESSENTIALS_WISHLIST_PRODUCT_NAME_REMOVED', $product_name), 'success');
			}
		}
		
		if (!empty($return))
		{
			$return = VMEssentialsHelperUtility::decode($return);
			
			if (JUri::isInternal($return))
			{
				$this->setRedirect(JRoute::_($return, false));
			}
		}
	}

	public function getStatus()
	{
		$model    = $this->getModel();
		$products = $model->getAllItemIds();
		
		$this->jsonReturn(array('error' => 0, 'msg' => '', 'products' => array_values($products)));
	}

	public function getModel($name = 'Wishlist', $prefix = 'VMEssentialsModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}
}
