<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

use \Joomla\CMS\Factory;

/**
 * VirtueMart Essentials Component Package Script
 * 
 * @since   1.0
 */
class pkg_vmessentialsInstallerScript
{
	/**
	 * Called on installation
	 *
	 * @param   Joomla\CMS\Installer\Adapter\PackageAdapter  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function install($adapter)
	{
		$app = Factory::getApplication();
		
		if ($this->enablePlugins())
		{
			$app->enqueueMessage('Essentials for VirtueMart package has been successfully installed in your site.', 'success');
		}
		
		return true;
	}

	/**
	 * Called on update
	 *
	 * @param   Joomla\CMS\Installer\Adapter\PackageAdapter  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function update($adapter)
	{
		$app = Factory::getApplication();
		
		if ($this->enablePlugins())
		{
			$app->enqueueMessage('Essentials for VirtueMart package has been successfully updated in your site.', 'success');
		}
		
		return true;
	}

	/**
	 * Called before any type of action
	 *
	 * @param     string                                         $route      Which action is happening (install|uninstall|discover_install)
	 * @param     Joomla\CMS\Installer\Adapter\PackageAdapter    $adapter    The object responsible for running this script
	 *
	 * @return    boolean             True on success
	 */
	public function preflight($route, $adapter)
	{
		return true;
	}


	/**
	 * Called after any type of action
	 *
	 * @param     string                                         $route      Which action is happening (install|uninstall|discover_install)
	 * @param     Joomla\CMS\Installer\Adapter\PackageAdapter    $adapter    The object responsible for running this script
	 *
	 * @return    boolean             True on success
	 */
	public function postflight($route, $adapter)
	{
		return true;
	}
	
	/**
	* Private method to enable all required plugins of the component
	* 
	* @return boolean
	*/
	private function enablePlugins()
	{
		$app     = Factory::getApplication();
		$plugins = $this->getPluginIDs();
		
		if ($plugins === false || !is_array($plugins))
		{
			$app->enqueueMessage('Please go to Plugin Manager and enable "System - Essentials for VirtueMart" plugin.');
			return false;
		}

		jimport('legacy.model.legacy');
		JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_plugins/models/', 'PluginsModel');

		$model = JModelLegacy::getInstance('Plugin', 'PluginsModel');
		
		if (!$model)
		{
			$app->enqueueMessage('Please go to Plugin Manager and enable "System - Essentials for VirtueMart" plugin.');
			return false;
		}
		
		$hasError = false;
		
		foreach ($plugins as $extension_id)
		{
			if (!$model->publish($extension_id, 1))
			{
				$hasError = true;
			}
		}
		
		if ($hasError)
		{
			$app->enqueueMessage('Please go to Plugin Manager and enable "System - VirtueMart Essentials" plugin.');
			return false;
		}
		
		return true;
	}

	/**
	* Private method to get the installed VirtueMart Essentials plugin IDs.
	* 
	* @return mixed(boolean/array)  false if not found.
	*/
	private function getPluginIDs()
	{
		$db    = Factory::getDBO();
		$query = $db->getQuery(true);
		
		$folders = array(
			$db->quote('system'), $db->quote('content'), $db->quote('user')
		);
		
		$query->select($db->quoteName('extension_id'))
			->from($db->quoteName('#__extensions'))
			->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
			->where($db->quoteName('element') . ' = ' . $db->quote('vmessentials'))
			->where($db->quoteName('folder') . ' IN (' . implode(',', $folders) . ')');

		try
		{
			$db->setQuery($query);
			$extension_ids = $db->loadColumn();
		}
		catch(Exception $e)
		{
			// We can not throw SQL error here.
			return false;
		}
		
		$extension_ids = empty($extension_ids) ? array() : (array) $extension_ids;
		
		return $extension_ids;
	}
}
