<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

// Access check.
if (!JFactory::getUser()->authorise('core.manage', 'com_vmessentials'))
{
	throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'));
}

// Include dependancies
jimport('joomla.application.component.controller');

JLoader::registerPrefix('VMEssentials', JPATH_COMPONENT_ADMINISTRATOR);

if (!defined('VMESSENTIALS_ADMINISTRATOR'))
{
	require_once(JPATH_ADMINISTRATOR . '/components/com_vmessentials/include.php');
}

if (!defined('VMESSENTIALS_ADMINISTRATOR'))
{
	return;
}

// Register helper class
JLoader::register('VMEssentialsHelper', VMESSENTIALS_ADMINISTRATOR . '/helpers/vmessentials.php');

// Check system
VMEssentialsHelper::checkSystem();

// Load VirtueMart Config and language
VmConfig::loadConfig();
VmConfig::loadJLang('com_virtuemart');

$controller = JControllerLegacy::getInstance('VMEssentials');
$controller->execute(JFactory::getApplication()->input->get('task'));
$controller->redirect();