<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

/**
 * View class for a list of VMEssentials.
 *
 * @since  1.6
 */
class VMEssentialsViewItems extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template name
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	public function display($tpl = null)
	{
		$this->state         = $this->get('State');
		$this->items         = $this->get('Items');
		$this->pagination    = $this->get('Pagination');
		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors));
		}

		VMEssentialsHelper::addSubmenu('items');

		$this->addToolbar();

		$this->sidebar = JHtmlSidebar::render();
		
		if ($this->state->get('filter.group'))
		{
			$this->setLayout('product');
		}
		
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return void
	 *
	 * @since    1.6
	 */
	protected function addToolbar()
	{
		$state = $this->get('State');
		$canDo = VMEssentialsHelper::getActions();

		JToolBarHelper::title(JText::_('COM_VMESSENTIALS') . ' - ' . JText::_('COM_VMESSENTIALS_TITLE_ITEMS'), 'stack article');

		if ($canDo->get('core.edit.state') && isset($this->items[0]))
		{
			JToolBarHelper::deleteList('', 'items.delete', 'JTOOLBAR_DELETE');
			
			$bar = JToolbar::getInstance('toolbar');

			// Add a preview button.
			$bar->appendButton('Link', 'download', 'Download', 'index.php?option=com_vmessentials&task=items.download&' . JSession::getFormToken() . '=1');
		}

		if ($canDo->get('core.admin'))
		{
			JToolBarHelper::preferences('com_vmessentials');
		}
	}
}
