<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');

if (!version_compare(JVERSION, '4.0.0', 'ge'))
{
	JHtml::_('bootstrap.tooltip');
	JHtml::_('behavior.multiselect');
	JHtml::_('formbehavior.chosen', 'select');
}

$app       = JFactory::getApplication();
$user      = JFactory::getUser();
$userId    = $user->get('id');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
?>
<form action="<?php echo JRoute::_('index.php?option=com_vmessentials&view=items'); ?>" method="post" name="adminForm" id="adminForm">
<?php if (!empty( $this->sidebar) && !version_compare(JVERSION, '4.0.0', 'ge')) : ?>
	<div id="j-sidebar-container" class="span2">
		<?php echo $this->sidebar; ?>
	</div>
	<div id="j-main-container" class="span10">
<?php else : ?>
	<div id="j-main-container">
<?php endif;?>
		<?php
		// Search tools bar
		echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
		?>
		<?php if (empty($this->items)) : ?>
			<div class="alert alert-no-items">
				<?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
			</div>
		<?php else : ?>
			<table class="table table-striped" id="articleList">
				<thead>
					<tr>
						<th width="1%" class="center">
							<?php echo JHtml::_('grid.checkall'); ?>
						</th>
						<th class="nowrap">
							<?php echo JHtml::_('searchtools.sort', 'COM_VMESSENTIALS_ITEMS_USER_ID', 'u.name', $listDirn, $listOrder); ?>
						</th>
						<th class="nowrap">
							<?php echo JHtml::_('searchtools.sort', 'COM_VIRTUEMART_PRODUCT_NAME', 'product_name', $listDirn, $listOrder); ?>
						</th>
						<th class="nowrap">
							<?php echo JHtml::_('searchtools.sort', 'COM_VIRTUEMART_VENDOR_NAME', 'v.vendor_name', $listDirn, $listOrder); ?>
						</th>
						<th width="10%" class="center">
							<?php echo JHtml::_('searchtools.sort', 'COM_VIRTUEMART_PRODUCT_FORM_IN_STOCK', 'product_stock', $listDirn, $listOrder); ?>
						</th>
						<th width="10%" class="nowrap hidden-phone">
							<?php echo JHtml::_('searchtools.sort', 'JDATE', 'a.`datetime`', $listDirn, $listOrder); ?>
						</th>
						<th width="10%" class="center">
							<?php echo JHtml::_('searchtools.sort', 'COM_VIRTUEMART_PRODUCT_ID', 'p.virtuemart_product_id', $listDirn, $listOrder); ?>
						</th>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<td colspan="7"></td>
					</tr>
				</tfoot>
				<tbody>
				<?php foreach ($this->items as $i => $item) : ?>
					<tr class="row<?php echo $i % 2; ?>">
						<td class="center">
							<?php echo JHtml::_('grid.id', $i, $item->id); ?>
						</td>
						<td>
							<a href="<?php echo JRoute::_('index.php?option=com_users&task=user.edit&id=' . $item->user_id); ?>">
								<?php echo $item->user_name; ?>
							</a>
						</td>
						<td>
							<a href="<?php echo JRoute::_('index.php?option=com_virtuemart&view=product&task=edit&virtuemart_product_id=' . $item->virtuemart_product_id) ?>">
								<?php echo $item->product_name; ?>
							</a>
						</td>
						<td class="small">
							<?php echo $item->vendor_name; ?>
						</td>
						<td class="center">
							<?php echo $item->product_stock; ?>
						</td>
						<td class="nowrap hidden-phone small">
							<?php if ($item->datetime != '0000-00-00 00:00:00') : ?>
								<?php echo JHtml::_('date', $item->datetime, JText::_('DATE_FORMAT_LC5')); ?>
							<?php else : ?>
								<?php echo '0000-00-00 00:00'; ?>
							<?php endif; ?>
						</td>
						<td class="center">
							<?php echo $item->virtuemart_product_id; ?>
						</td>
					</tr>
					<?php endforeach; ?>
				</tbody>
			</table>
		<?php endif;?>

		<?php echo $this->pagination->getListFooter(); ?>

		<input type="hidden" name="task" value="" />
		<input type="hidden" name="byproduct" value="0" />
		<input type="hidden" name="boxchecked" value="0" />
		<?php echo JHtml::_('form.token'); ?>
	</div>
</form>