/**
 * @package    VP Advanced User
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2016 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */
! function($) {
    $(function() {

        var vpdk = window.vpdk || {};

        vpdk.showTimeout = null;
        vpdk.hideTimeout = null;
        vpdk.ajaxTimeout = null;

        vpdk.modalBg = $('<div class="vpdk-modal-bg"></div>');
        vpdk.modalBg.appendTo('body');

        vpdk.show = function(modal) {
            if (vpdk.showTimeout) {
                clearTimeout(vpdk.showTimeout);
            }
            $('body').addClass('vpdk-modal-open');
            vpdk.modalBg.addClass('vpdk-fade');
            modal.addClass('vpdk-fade');
            vpdk.showTimeout = setTimeout(function() {
                vpdk.modalBg.addClass('vpdk-in');
                modal.addClass('vpdk-in');
            }, 20);
        };

        vpdk.hide = function(modal) {
            if (vpdk.hideTimeout) {
                clearTimeout(vpdk.hideTimeout);
            }
            $('body').removeClass('vpdk-modal-open');
            vpdk.modalBg.removeClass('vpdk-in');
            modal.removeClass('vpdk-in');
            vpdk.hideTimeout = setTimeout(function() {
                vpdk.modalBg.removeClass('vpdk-fade');
                modal.removeClass('vpdk-fade');
            }, 150);
        };

        vpdk.showMsg = function(messageBox, type, msg) {
            type = !type ? 'error' : type;
            var $html = $('<div class="vpdk-alert vpdk-alert-' + type + '"></div>');
            $html.html(msg);
            messageBox.html($html);
        }

        vpdk.hideMsg = function(messageBox) {
            messageBox.text('');
        }

        vpdk.showSystemMsg = function(type, msg) {
            type = !type ? 'error' : type;
            var $html = $('<div class="vpdk-alert vpdk-alert-' + type + '"></div>');
            $html.html(msg);
            $('div#system-message-container').html($html);
            $("html,body").animate({
                scrollTop: $("div#system-message-container").offset().top - 100
            }, 500);
        }

        vpdk.hideSystemMsg = function() {
            $('div#system-message-container').text('');
        }

        $('[data-vpdk]').each(function() {
            var vpdki = vpdk;
            vpdki.field = $(this);
            vpdki.parentForm = $(this).closest('form');
            vpdki.actionURL = vpdki.parentForm.attr('action');
            vpdki.id = vpdki.field.attr('id');
            vpdki.btn = $('button#' + vpdki.id + '-button');
            vpdki.clearBtn = $('button#' + vpdki.id + '-clear-button');
            vpdki.revalBtn = $('button#' + vpdki.id + '-reval-button');
            vpdki.tmpl = $('script#' + vpdki.id + '-tmpl');
            vpdki.html = $(vpdki.tmpl.html());

            vpdki.html.appendTo('body');
            vpdki.tmpl.remove();

            vpdki.hiddenField = $('input#' + vpdki.id + '-hidden');
            vpdki.modal = $('#' + vpdki.id + '-tmpl-modal');
            vpdki.form = vpdki.modal.find('form');
            vpdki.msgBox = vpdki.modal.find('.vpdk-modal-message');
            vpdki.unameField = vpdki.form.find('input#' + vpdki.id + '-tmpl-uname');
            vpdki.dlkField = vpdki.form.find('input#' + vpdki.id + '-tmpl-dlk');
            vpdki.confBtn = vpdki.form.find('button#' + vpdki.id + '-tmpl-button');
            vpdki.cancelBtn = vpdki.form.find('button#' + vpdki.id + '-tmpl-cancel');
            vpdki.closeBtn = vpdki.modal.find('button.vpdk-modal-close');
            vpdki.url = vpdki.form.data('action');
            vpdki.modalLoader = vpdki.modal.find('.vpdk-modal-inner-bg');
            vpdki.infoNoaccess = vpdki.field.siblings('.vpdk-info-box').find('.vpdk-info-noaccess');
            vpdki.infoValid = vpdki.field.siblings('.vpdk-info-box').find('.vpdk-info-valid');
            vpdki.infoDefault = vpdki.field.siblings('.vpdk-info-box').find('.vpdk-info-default');

            vpdki.btn.click(function(e) {
                e.preventDefault();
                vpdk.show(vpdki.modal);
                vpdk.hideSystemMsg();
                return false;
            });

            vpdki.clearBtn.click(function(e) {
                e.preventDefault();
                vpdki.field.val('').trigger('change');
                vpdki.hiddenField.val('').trigger('change');
                vpdk.hideSystemMsg();
                return false;
            });

            vpdki.field.change(function() {
                if ($(this).val() == '') {
                    vpdki.btn.removeClass('vpdk-show-edit');
                    vpdki.clearBtn.addClass('vpdk-hide');
                    vpdki.revalBtn.addClass('vpdk-hide');
                    vpdki.infoValid.addClass('vpdk-hide');
                    vpdki.infoNoaccess.addClass('vpdk-hide');
                    vpdki.infoDefault.removeClass('vpdk-hide');
                } else {
                    vpdki.btn.addClass('vpdk-show-edit');
                    vpdki.clearBtn.removeClass('vpdk-hide');
                    vpdki.revalBtn.removeClass('vpdk-hide');
                    if ($(this).data('vpdkaccess') == '0') {
                        vpdki.infoNoaccess.removeClass('vpdk-hide');
                        vpdki.infoDefault.addClass('vpdk-hide');
                        vpdki.infoValid.addClass('vpdk-hide');
                    } else {
                        vpdki.infoDefault.addClass('vpdk-hide');
                        vpdki.infoNoaccess.addClass('vpdk-hide');
                        vpdki.infoValid.removeClass('vpdk-hide');
                    }
                }
            });

            vpdki.cancelBtn.click(function(e) {
                vpdk.hideMsg(vpdki.msgBox);
                vpdk.hide(vpdki.modal);
                vpdk.hideSystemMsg();
            });

            vpdki.closeBtn.click(function(e) {
                vpdk.hideMsg(vpdki.msgBox);
                vpdk.hide(vpdki.modal);
                vpdk.hideSystemMsg();
            });

            vpdki.confBtn.click(function() {
                vpdk.hideMsg(vpdki.msgBox);
                vpdki.uname = vpdki.unameField.val();
                vpdki.uname = !vpdki.uname ? vpdki.uname : $.trim(vpdki.uname);
                vpdki.dlk = vpdki.dlkField.val();
                vpdki.dlk = !vpdki.dlk ? vpdki.dlk : $.trim(vpdki.dlk);
                vpdki.timeOut;

                if (!vpdki.uname) {
                    vpdk.showMsg(vpdki.msgBox, 'error', 'Please provide a valid Username.');
                    return false;
                }
                if (!vpdki.dlk) {
                    vpdk.showMsg(vpdki.msgBox, 'error', 'Please provide a valid Download Key.');
                    return false;
                }

                if (vpdk.ajaxTimeout) clearTimeout(vpdk.ajaxTimeout);

                vpdk.ajaxTimeout = $.ajax({
                    type: 'GET',
                    dataType: 'JSON',
                    url: vpdki.url,
                    cache: false,
                    data: {
                        method: 'validatedlk',
                        uname: encodeURIComponent(vpdki.uname),
                        dlk: encodeURIComponent(vpdki.dlk)
                    },
                    beforeSend: function() {
                        vpdki.modalLoader.addClass('vpdk-fade').addClass('vpdk-in');
                    },
                    success: function(e) {
                        vpdki.modalLoader.removeClass('vpdk-fade').removeClass('vpdk-in');
                        if (!e) {
                            vpdk.showMsg(vpdki.msgBox, 'error', 'Validation failed. Please check your internet connection. If problem persists please contact VirtuePlanet support.');
                            return false;
                        }
                        if (e.error) {
                            vpdk.showMsg(vpdki.msgBox, 'error', e.msg);
                            return false;
                        }
                        if (!e.return.valid) {
                            vpdk.showMsg(vpdki.msgBox, 'error', e.return.message);
                            return false;
                        }
                        if (!e.return.access) {
                            vpdk.showMsg(vpdki.msgBox, 'warning', e.return.message);
                            vpdki.field.data('vpdkaccess', '0').attr('data-vpdkaccess', '0');
                        } else {
                            vpdk.showMsg(vpdki.msgBox, 'success', e.return.message);
                            vpdki.field.data('vpdkaccess', '1').attr('data-vpdkaccess', '1');
                        }
                        vpdki.field.val(e.return.dlk).trigger('change');
                        vpdki.hiddenField.val(e.return.data).trigger('change');
                        if (vpdki.timeOut) clearTimeout(vpdki.timeOut);
                        vpdki.timeOut = setTimeout(function() {
                            vpdk.hide(vpdki.modal);
                            vpdki.form[0].reset();
                            vpdk.hideMsg(vpdki.msgBox);
                        }, 500);
                    },
                    error: function(e, t, n) {
                        console.log(e);
                        console.log(t);
                        console.log(n);
                        vpdki.modalLoader.removeClass('vpdk-fade').removeClass('vpdk-in');
                        vpdk.showMsg(vpdki.msgBox, 'warning', 'Validation failed. Please check your internet connection. If problem persists please contact VirtuePlanet support.');
                    }
                });
            });

            vpdki.revalBtn.click(function() {
                vpdk.hideSystemMsg()
                if (vpdk.ajaxTimeout) clearTimeout(vpdk.ajaxTimeout);

                vpdk.ajaxTimeout = $.ajax({
                    type: 'GET',
                    dataType: 'JSON',
                    url: vpdki.url,
                    cache: false,
                    data: {
                        method: 'revalidatedlk',
                        data: vpdki.hiddenField.val()
                    },
                    beforeSend: function() {
                        vpdki.revalBtn.attr('disabled', true);
                    },
                    success: function(e) {
                        vpdki.revalBtn.removeAttr('disabled');
                        if (!e) {
                            vpdk.showSystemMsg('error', 'Validation failed. Please check your internet connection. If problem persists please contact VirtuePlanet support.');
                            return false;
                        }
                        if (e.error) {
                            vpdk.showSystemMsg('error', e.msg);
                            return false;
                        }
                        if (!e.return.valid) {
                            vpdk.showSystemMsg('error', e.return.message);
                            return false;
                        }
                        if (!e.return.access) {
                            vpdk.showSystemMsg('warning', e.return.message);
                            vpdki.field.data('vpdkaccess', '0').attr('data-vpdkaccess', '0');
                        } else {
                            vpdk.showSystemMsg('success', e.return.message);
                            vpdki.field.data('vpdkaccess', '1').attr('data-vpdkaccess', '1');
                        }
                        vpdki.field.val(e.return.dlk).trigger('change');
                        vpdki.hiddenField.val(e.return.data).trigger('change');
                    },
                    error: function(e, t, n) {
                        console.log(e);
                        console.log(t);
                        console.log(n);
                        vpdki.revalBtn.removeAttr('disabled');
                        vpdk.showSystemMsg('warning', 'Validation failed. Please check your internet connection. If problem persists please contact VirtuePlanet support.');
                    }
                });
            });
            if (vpdki.revalBtn.data('vpdkvalidate') == 'auto') {
                vpdki.revalBtn.trigger('click');
            }
            $(document).on('vpcom.save.config', function(event, field) {
                var $field = $(field);
                if (!$field || !$field.length) {
                    return false;
                }
                var $form = $field.closest('form');
                if (!$form.length) {
                    return false;
                }

                var data, key;
                // Get the parameters as an array
                data = $form.serializeArray();
                // Find and replace task if there
                for (key = 0; key < data.length; ++key) {
                    if (data[key].name == 'task') {
                        data[key].value = 'config.save.component.apply';
                        break;
                    }
                }
                // Add it if it wasn't there
                if (key >= data.length) {
                    data.push({
                        name: 'task',
                        value: 'config.save.component.apply'
                    });
                }
                // Convert to URL-encoded string
                data = $.param(data);
                $.ajax({
                    type: 'POST',
                    url: $form.attr('action'),
                    data: data,
                    success: function() {
                        console.log('Success vpcom.save.config');
                    }
                });
            });
        });
    });
}(jQuery);