<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldVmvendors extends JFormFieldList
{
	protected $type = 'Vmvendors';
	
	protected static $vendors = null;
	
	protected function getOptions()
	{
		if (self::$vendors === null)
		{
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			
			$query->select($db->quoteName('virtuemart_vendor_id') . ' AS ' . $db->quoteName('value'))
				->select($db->quoteName('vendor_name') . ' AS ' . $db->quoteName('text'))
				->from($db->quoteName('#__virtuemart_vendors'));

			$db->setQuery($query);
			
			self::$vendors = $db->loadObjectList();
		}
		
		$options = array();
		
		foreach (self::$vendors as $vendor)
		{
			$options[] = JHtml::_('select.option', (int) $vendor->value, $vendor->text);
		}
		
		return array_merge(parent::getOptions(), $options);
	}
}