<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

JFormHelper::loadFieldClass('list');

class JFormFieldVmfields extends JFormFieldList
{
	protected $type = 'Vmfields';
	
	protected static $cfields = null;
	
	protected function getOptions()
	{
		if (self::$cfields === null)
		{
			$db = JFactory::getDbo();
			$query = $db->getQuery(true);
			
			$query->select($db->quoteName(array('virtuemart_custom_id', 'custom_title')))
				->from($db->quoteName('#__virtuemart_customs'))
				->where($db->quoteName('field_type') . ' NOT IN ("G", "R", "Z")')
				->where($db->quoteName('is_cart_attribute') . ' = 0')
				->where($db->quoteName('is_input') . ' = 0')
				->where($db->quoteName('admin_only') . ' = 0')
				->where($db->quoteName('published') . ' = 1');

			$db->setQuery($query);
			self::$cfields = $db->loadObjectList();
		}
		
		$options = array();
		
		foreach (self::$cfields as $field)
		{
			$options[] = JHtml::_('select.option', (int) $field->virtuemart_custom_id, $field->custom_title);
		}
		
		return array_merge(parent::getOptions(), $options);
	}
}
