<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

jimport('joomla.form.formfield');

JFormHelper::loadFieldClass('text');

class JFormFieldVmesearch extends JFormFieldText
{
	public $type = 'Vmesearch';
	
	protected static $products = null;
	
	protected function getInput()
	{
		$html = array();
		
		if (!version_compare(JVERSION, '4.0.0', 'ge'))
		{
			$html[] = '<div class="btn-wrapper input-append">';
		}
		else
		{
			$html[] = '<div class="btn-wrapper input-group">';
		}
		
		$html[] = parent::getInput();
		
		if (!version_compare(JVERSION, '4.0.0', 'ge'))
		{
			$html[] = '<button type="submit" class="btn hasTooltip" title="Search"><span class="icon-search"></span></button>';
		}
		else
		{
			$html[] = '<button type="submit" class="btn btn-secondary hasTooltip" title="Search"><span class="icon-search"></span></button>';
		}
		
		$html[] = '</div>';
		
		JFactory::getDocument()->addStyleDeclaration(".input-append input[type=\"text\"].active{background:#fff;border-color:#ccc;}");
		
		return implode($html);
	}
}