<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

class JFormFieldVmeinfo extends JFormField
{
	protected $type = 'Vmeinfo';
	
	function getInput()
	{
		return '';
	}
	
	protected function getLabel()
	{
		$label = isset($this->element['label']) ? $this->element['label'] : '';
		$info  = isset($this->element['info']) ? $this->element['info'] : '';
		$link  = isset($this->element['link']) ? $this->element['link'] : '';
		
		if (empty($label) && empty($info))
		{
			return '';
		}
		
		$html   = array();
		$html[] = '</div>';
		$html[] = '<div class="alert alert-info" style="padding:15px;border-radius:0;margin-top:20px;">';
		
		if (!empty($label))
		{
			$html[] = '<h4>';
			$html[] = JText::_($label);
			$html[] = '</h4>';
		}
		
		if (!empty($info))
		{
			if (!empty($link))
			{
				$part_1 = '<a href="' . $link . '" target="_blank">';
				$part_2 = '</a>';
				
				$html[] = JText::sprintf($info, $part_1, $part_2);
			}
			else
			{
				$html[] = JText::_($info);
			}
		}

		$html[] = '</div>';
		$html[] = '<div>';
		
		return implode($html);
	}
}