<?php
/**
 * @package    Essentials for VirtueMart
 * @author     Abhishek Das <info@virtueplanet.com>
 * @copyright  Copyright (C) 2012-2024 VirtuePlanet Services LLP. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       https://www.virtueplanet.com
 */

defined('_JEXEC') or die;

$app = JFactory::getApplication();

JLoader::register('VmConfig', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/config.php');

if (!class_exists('VmConfig'))
{
	if ($app->isClient('administrator'))
	{
		$app->enqueueMessage('Essentials for VirtueMart needs VirtueMart component.');
	}
	
	return false;
}

// Define own paths
defined('VMESSENTIALS_ADMINISTRATOR') or define('VMESSENTIALS_ADMINISTRATOR', JPATH_ADMINISTRATOR . '/components/com_vmessentials');
defined('VMESSENTIALS_SITE') or define('VMESSENTIALS_SITE', JPATH_SITE . '/components/com_vmessentials');

// Register all required VirtueMart classes to Joomla autoloader
JLoader::register('VirtueMartModelVendor', JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/vendor.php');
JLoader::register('calculationHelper', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/calculationh.php');
JLoader::register('ShopFunctions', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/shopfunctions.php');
JLoader::register('VmImage', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/image.php');
JLoader::register('TableMedias', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/medias.php');
JLoader::register('TableCategories', JPATH_ADMINISTRATOR . '/components/com_virtuemart/tables/categories.php');
JLoader::register('VirtueMartModelCategory', JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/category.php');
JLoader::register('VirtueMartModelProduct', JPATH_ADMINISTRATOR . '/components/com_virtuemart/models/product.php');
JLoader::register('CurrencyDisplay', JPATH_ADMINISTRATOR . '/components/com_virtuemart/helpers/currencydisplay.php');
JLoader::register('vmCustomPlugin', JPATH_ADMINISTRATOR . '/components/com_virtuemart/plugins/vmcustomplugin.php');

// Internal debugging function
if (!function_exists('vpdump'))
{
	/**
	* Method to print any data with debug information.
	* Used in debuggin purpose. Similar to vardump but more advanced.
	* 
	* @param mixed $data Any type of data but form xml object
	* 
	* @return void
	*/
	function vpdump($data, $debug = true)
	{
		ob_start();
		print_r($data);
		$str = ob_get_contents();
		ob_end_clean();

		echo '<pre class="vpdump" dir="ltr" style="font-size: 14px;">';
		echo '<small>' . gettype($data) . '</small> ';
		echo '<font color="#cc0000">' . $str . '</font>';
		echo '<i>{Length: ' . strlen($str) . '}</i>';
		
		if ($debug)
		{
			$backTraces = function_exists('debug_backtrace') ? debug_backtrace() : array();
			
			echo '<ul style="margin:15px 0; padding:15px; list-style-position:inside; background: #FAFAFA; border: 1px solid #DDD; line-height: 1.4;">';
			
			foreach ($backTraces as $backTrace)
			{
				echo '<li>';
				echo '<b>File:</b> ' . $backTrace['file'] . '  <b>Line:</b> ' . $backTrace['line'] . (isset($backTrace['class']) ? '  <b>Class:</b> ' . $backTrace['class'] : '') . (isset($backTrace['class']) ? '  <b>Function:</b> ' . $backTrace['function'] : '');
				echo '</li>';
			}
			
			echo '<li><b>Current Memory Usage:</b> ' . vpCalculateSize(memory_get_usage()) . '</li>';
			echo '<li><b>Peak Memory Usage:</b> ' . vpCalculateSize(memory_get_peak_usage()) . '</li>';
			
			echo '</ul>';
		}
		
		echo '<br/>';
		echo '</pre>';
	}
}

if (!function_exists('vpCalculateSize'))
{
	function vpCalculateSize($mem_usage)
	{
		if ($mem_usage < 1024) 
			return $mem_usage.' bytes'; 
		elseif ($mem_usage < 1048576) 
			return round($mem_usage/1024, 2).' KB'; 
		else 
			return round($mem_usage/1048576, 2).' MB';
	}
}
